/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.liveobject.misc;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ClassUtils {
    public static void setField(Object obj, String fieldName, Object value) {
        try {
            Field field = obj.getClass().getDeclaredField(fieldName);
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            field.set(obj, value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T extends Annotation> T getAnnotation(Class<?> clazz, String fieldName, Class<T> annotationClass) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            return field.getAnnotation(annotationClass);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public static <T> T getField(Object obj, String fieldName) {
        try {
            Field field = obj.getClass().getDeclaredField(fieldName);
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            return (T)field.get(obj);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Method searchForMethod(Class type, String name, Class[] parms) {
        try {
            return type.getMethod(name, parms);
        }
        catch (NoSuchMethodException e) {
            Method[] methods = type.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Class[] types;
                if (!methods[i].getName().equals(name) || (types = methods[i].getParameterTypes()).length != parms.length || !ClassUtils.areTypesCompatible(types, parms)) continue;
                return methods[i];
            }
            return null;
        }
    }

    private static boolean areTypesCompatible(Class[] targets, Class[] sources) {
        if (targets.length != sources.length) {
            return false;
        }
        for (int i = 0; i < targets.length; ++i) {
            if (sources[i] == null || ClassUtils.translateFromPrimitive(targets[i]).isAssignableFrom(sources[i])) continue;
            return false;
        }
        return true;
    }

    private static Class<?> translateFromPrimitive(Class<?> primitive) {
        if (!primitive.isPrimitive()) {
            return primitive;
        }
        if (Boolean.TYPE.equals(primitive)) {
            return Boolean.class;
        }
        if (Character.TYPE.equals(primitive)) {
            return Character.class;
        }
        if (Byte.TYPE.equals(primitive)) {
            return Byte.class;
        }
        if (Short.TYPE.equals(primitive)) {
            return Short.class;
        }
        if (Integer.TYPE.equals(primitive)) {
            return Integer.class;
        }
        if (Long.TYPE.equals(primitive)) {
            return Long.class;
        }
        if (Float.TYPE.equals(primitive)) {
            return Float.class;
        }
        if (Double.TYPE.equals(primitive)) {
            return Double.class;
        }
        throw new RuntimeException("Error translating type:" + primitive);
    }
}

