/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.action;

import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.rx.Stream;
import reactor.rx.StreamUtils;
import reactor.rx.action.Action;

public final class CompositeAction<E, O>
extends Action<E, O> {
    private final Action<?, O> publisher;
    private final Action<E, ?> subscriber;

    public CompositeAction(Action<E, ?> head, Action<?, O> tail) {
        super(head.getCapacity());
        this.publisher = tail;
        this.subscriber = head;
    }

    public Stream<O> output() {
        return this.publisher;
    }

    public Action<E, ?> input() {
        return this.subscriber;
    }

    @Override
    public void subscribe(Subscriber<? super O> s) {
        this.publisher.subscribe(s);
    }

    @Override
    public void onSubscribe(Subscription s) {
        this.subscriber.onSubscribe(s);
    }

    @Override
    public void onNext(E e) {
        this.subscriber.onNext(e);
    }

    @Override
    public void onError(Throwable t) {
        this.subscriber.onError(t);
    }

    @Override
    public void onComplete() {
        this.subscriber.onComplete();
    }

    @Override
    public StreamUtils.StreamVisitor debug() {
        return this.publisher.debug();
    }

    @Override
    public Action<E, O> capacity(long elements) {
        this.publisher.capacity(elements);
        this.subscriber.capacity(elements);
        return super.capacity(elements);
    }

    @Override
    public void cancel() {
        this.publisher.cancel();
        this.subscriber.cancel();
        super.cancel();
    }

    @Override
    public String toString() {
        return "input=" + (this.subscriber.getClass().getSimpleName().isEmpty() ? this.subscriber : this.subscriber.getClass().getSimpleName().replaceAll("Action", "")) + ", output=" + (this.publisher.getClass().getSimpleName().isEmpty() ? this.publisher : this.publisher.getClass().getSimpleName().replaceAll("Action", ""));
    }

    @Override
    protected void doNext(E ev) {
    }
}

