/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import org.reactivestreams.Publisher;
import org.redisson.api.RFuture;
import org.redisson.api.RObjectReactive;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandReactiveExecutor;
import reactor.rx.Stream;
import reactor.rx.Streams;

abstract class RedissonObjectReactive
implements RObjectReactive {
    final CommandReactiveExecutor commandExecutor;
    private final String name;
    final Codec codec;

    public RedissonObjectReactive(Codec codec, CommandReactiveExecutor commandExecutor, String name) {
        this.codec = codec;
        this.name = name;
        this.commandExecutor = commandExecutor;
    }

    public <R> Publisher<R> reactive(RFuture<R> future) {
        return this.commandExecutor.reactive(future);
    }

    public RedissonObjectReactive(CommandReactiveExecutor commandExecutor, String name) {
        this(commandExecutor.getConnectionManager().getCodec(), commandExecutor, name);
    }

    protected <V> Stream<V> newSucceeded(V result) {
        return Streams.just(result);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Publisher<Void> rename(String newName) {
        return this.commandExecutor.writeReactive(this.getName(), RedisCommands.RENAME, this.getName(), newName);
    }

    @Override
    public Publisher<Void> migrate(String host, int port, int database) {
        return this.commandExecutor.writeReactive(this.getName(), RedisCommands.MIGRATE, host, port, this.getName(), database);
    }

    @Override
    public Publisher<Boolean> move(int database) {
        return this.commandExecutor.writeReactive(this.getName(), RedisCommands.MOVE, this.getName(), database);
    }

    @Override
    public Publisher<Boolean> renamenx(String newName) {
        return this.commandExecutor.writeReactive(this.getName(), RedisCommands.RENAMENX, this.getName(), newName);
    }

    @Override
    public Publisher<Boolean> delete() {
        return this.commandExecutor.writeReactive(this.getName(), RedisCommands.DEL_BOOL, this.getName());
    }

    @Override
    public Publisher<Boolean> isExists() {
        return this.commandExecutor.readReactive(this.getName(), this.codec, RedisCommands.EXISTS, this.getName());
    }
}

