/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.buffer.ByteBufUtil;
import io.netty.util.internal.ThreadLocalRandom;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.redisson.Redisson;
import org.redisson.api.RFuture;
import org.redisson.api.RedissonClient;
import org.redisson.client.RedisConnection;
import org.redisson.config.RedissonNodeConfig;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.misc.RedissonThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedissonNode {
    private static final Logger log = LoggerFactory.getLogger(RedissonNode.class);
    private ExecutorService executor;
    private RedissonClient redisson;
    private final RedissonNodeConfig config;
    private final String id;
    private InetSocketAddress remoteAddress;
    private InetSocketAddress localAddress;

    private RedissonNode(RedissonNodeConfig config) {
        this.config = new RedissonNodeConfig(config);
        this.id = this.generateId();
    }

    public InetSocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public String getId() {
        return this.id;
    }

    private String generateId() {
        byte[] id = new byte[8];
        ThreadLocalRandom.current().nextBytes(id);
        return ByteBufUtil.hexDump(id);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            throw new IllegalArgumentException("Config file not defined");
        }
        String configPath = args[0];
        RedissonNodeConfig config = null;
        try {
            config = RedissonNodeConfig.fromJSON(new File(configPath));
        }
        catch (IOException e) {
            try {
                config = RedissonNodeConfig.fromYAML(new File(configPath));
            }
            catch (IOException e1) {
                log.error("Can't parse json config " + configPath, e);
                throw new IllegalArgumentException("Can't parse yaml config " + configPath, e1);
            }
        }
        final RedissonNode node = RedissonNode.create(config);
        node.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                node.shutdown();
            }
        });
    }

    public void shutdown() {
        if (this.executor != null) {
            log.info("Worker executor is being shutdown...");
            this.executor.shutdown();
            try {
                if (this.executor.awaitTermination(5L, TimeUnit.MINUTES)) {
                    log.info("Worker executor has been shutdown successfully");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.redisson.shutdown();
        log.info("Redisson node has been shutdown successfully");
    }

    public void start() {
        if (this.config.getExecutorServiceThreads() == 0) {
            this.executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2, new RedissonThreadFactory());
        } else if (this.config.getExecutorServiceThreads() > 0) {
            this.executor = Executors.newFixedThreadPool(this.config.getExecutorServiceThreads(), new RedissonThreadFactory());
        }
        this.redisson = Redisson.create(this.config);
        this.retrieveAdresses();
        if (this.config.getRedissonNodeInitializer() != null) {
            this.config.getRedissonNodeInitializer().onStartup(this.redisson, this);
        }
        for (Map.Entry<String, Integer> entry : this.config.getExecutorServiceWorkers().entrySet()) {
            String name = entry.getKey();
            int workers = entry.getValue();
            this.redisson.getExecutorService(name).registerWorkers(workers, this.executor);
            log.info("{} worker(s) for '{}' ExecutorService registered", (Object)workers, (Object)name);
        }
        log.info("Redisson node started!");
    }

    private void retrieveAdresses() {
        ConnectionManager connectionManager = ((Redisson)this.redisson).getConnectionManager();
        for (MasterSlaveEntry entry : connectionManager.getEntrySet()) {
            RFuture<RedisConnection> readFuture = entry.connectionReadOp();
            if (readFuture.awaitUninterruptibly(connectionManager.getConfig().getConnectTimeout()) && readFuture.isSuccess()) {
                RedisConnection connection = readFuture.getNow();
                entry.releaseRead(connection);
                this.remoteAddress = (InetSocketAddress)connection.getChannel().remoteAddress();
                this.localAddress = (InetSocketAddress)connection.getChannel().localAddress();
                return;
            }
            RFuture<RedisConnection> writeFuture = entry.connectionWriteOp();
            if (!writeFuture.awaitUninterruptibly(connectionManager.getConfig().getConnectTimeout()) || !writeFuture.isSuccess()) continue;
            RedisConnection connection = writeFuture.getNow();
            entry.releaseWrite(connection);
            this.remoteAddress = (InetSocketAddress)connection.getChannel().remoteAddress();
            this.localAddress = (InetSocketAddress)connection.getChannel().localAddress();
            return;
        }
    }

    public static RedissonNode create(RedissonNodeConfig config) {
        if (config.getExecutorServiceWorkers().isEmpty()) {
            throw new IllegalArgumentException("Executor service workers are empty");
        }
        return new RedissonNode(config);
    }
}

