/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.redisson.RedissonLock;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonFuture;
import org.redisson.misc.RedissonPromise;

public class RedissonMultiLock
implements Lock {
    final List<RLock> locks = new ArrayList<RLock>();

    public RedissonMultiLock(RLock ... locks) {
        if (locks.length == 0) {
            throw new IllegalArgumentException("Lock objects are not defined");
        }
        this.locks.addAll(Arrays.asList(locks));
    }

    @Override
    public void lock() {
        try {
            this.lockInterruptibly();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void lock(long leaseTime, TimeUnit unit) {
        try {
            this.lockInterruptibly(leaseTime, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void lockInterruptibly(long leaseTime, TimeUnit unit) throws InterruptedException {
        RedissonPromise<Void> promise = new RedissonPromise<Void>(ImmediateEventExecutor.INSTANCE.newPromise());
        long currentThreadId = Thread.currentThread().getId();
        ConcurrentLinkedQueue<RLock> lockedLocks = new ConcurrentLinkedQueue<RLock>();
        this.lock(promise, 0L, leaseTime, unit, this.locks, currentThreadId, lockedLocks);
        promise.sync();
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.lockInterruptibly(-1L, null);
    }

    private void lock(final RPromise<Void> promise, final long waitTime, final long leaseTime, final TimeUnit unit, final List<RLock> locks, final long currentThreadId, final Queue<RLock> lockedLocks) throws InterruptedException {
        final AtomicInteger tryLockRequestsAmount = new AtomicInteger();
        final HashMap tryLockFutures = new HashMap(locks.size());
        FutureListener<Boolean> listener = new FutureListener<Boolean>(){
            AtomicReference<RLock> lockedLockHolder = new AtomicReference();
            AtomicReference<Throwable> failed = new AtomicReference();

            @Override
            public void operationComplete(Future<Boolean> future) throws Exception {
                Boolean res;
                if (RedissonMultiLock.this.isLockFailed(future)) {
                    this.failed.compareAndSet(null, future.cause());
                }
                if ((res = future.getNow()) != null) {
                    RLock lock = (RLock)tryLockFutures.get(future);
                    if (res.booleanValue()) {
                        lockedLocks.add(lock);
                    } else {
                        this.lockedLockHolder.compareAndSet(null, lock);
                    }
                }
                if (tryLockRequestsAmount.decrementAndGet() == 0) {
                    if (RedissonMultiLock.this.isAllLocksAcquired(this.lockedLockHolder, this.failed, lockedLocks)) {
                        promise.setSuccess(null);
                        return;
                    }
                    if (lockedLocks.isEmpty()) {
                        this.tryLockAgain(promise, waitTime, leaseTime, unit, currentThreadId, tryLockFutures);
                        return;
                    }
                    final AtomicInteger locksToUnlockAmount = new AtomicInteger(lockedLocks.size());
                    for (RLock lock : lockedLocks) {
                        lock.unlockAsync().addListener(new FutureListener<Void>(){

                            @Override
                            public void operationComplete(Future<Void> future) throws Exception {
                                if (locksToUnlockAmount.decrementAndGet() == 0) {
                                    this.tryLockAgain(promise, waitTime, leaseTime, unit, currentThreadId, tryLockFutures);
                                }
                            }
                        });
                    }
                }
            }

            protected void tryLockAgain(final RPromise<Void> promise2, final long waitTime2, final long leaseTime2, final TimeUnit unit2, final long currentThreadId2, final Map<Future<Boolean>, RLock> tryLockFutures2) throws InterruptedException {
                lockedLocks.clear();
                if (this.failed.get() != null) {
                    promise2.setFailure(this.failed.get());
                } else if (this.lockedLockHolder.get() != null) {
                    final RedissonLock lockedLock = (RedissonLock)this.lockedLockHolder.get();
                    lockedLock.lockAsync(leaseTime2, unit2, currentThreadId2).addListener(new FutureListener<Void>(){

                        @Override
                        public void operationComplete(Future<Void> future) throws Exception {
                            if (!future.isSuccess()) {
                                promise2.setFailure(future.cause());
                                return;
                            }
                            lockedLocks.add(lockedLock);
                            ArrayList newLocks = new ArrayList(tryLockFutures2.values());
                            newLocks.remove(lockedLock);
                            RedissonMultiLock.this.lock(promise2, waitTime2, leaseTime2, unit2, newLocks, currentThreadId2, lockedLocks);
                        }
                    });
                } else {
                    RedissonMultiLock.this.lock(promise2, waitTime2, leaseTime2, unit2, locks, currentThreadId2, lockedLocks);
                }
            }
        };
        for (RLock lock : locks) {
            tryLockRequestsAmount.incrementAndGet();
            Future future = waitTime > 0L || leaseTime > 0L ? ((RedissonPromise)((RedissonLock)lock).tryLockAsync(waitTime, leaseTime, unit, currentThreadId)).getInnerPromise() : ((RedissonPromise)((RedissonLock)lock).tryLockAsync(currentThreadId)).getInnerPromise();
            if (future instanceof RedissonPromise) {
                future = ((RedissonPromise)((Object)future)).getInnerPromise();
            } else if (future instanceof RedissonFuture) {
                future = ((RedissonFuture)((Object)future)).getInnerFuture();
            }
            tryLockFutures.put(future, lock);
        }
        for (Future future : tryLockFutures.keySet()) {
            future.addListener(listener);
        }
    }

    @Override
    public boolean tryLock() {
        HashMap<RLock, RFuture<Boolean>> tryLockFutures = new HashMap<RLock, RFuture<Boolean>>(this.locks.size());
        for (RLock lock : this.locks) {
            tryLockFutures.put(lock, lock.tryLockAsync());
        }
        return this.sync(tryLockFutures);
    }

    protected boolean sync(Map<RLock, RFuture<Boolean>> tryLockFutures) {
        ArrayList<RLock> lockedLocks = new ArrayList<RLock>(tryLockFutures.size());
        RuntimeException latestException = null;
        for (Map.Entry<RLock, RFuture<Boolean>> entry : tryLockFutures.entrySet()) {
            try {
                if (!entry.getValue().syncUninterruptibly().getNow().booleanValue()) continue;
                lockedLocks.add(entry.getKey());
            }
            catch (RuntimeException e) {
                latestException = e;
            }
        }
        if (lockedLocks.size() < tryLockFutures.size()) {
            this.unlockInner(lockedLocks);
            if (latestException != null) {
                throw latestException;
            }
            return false;
        }
        return true;
    }

    protected void unlockInner(Collection<RLock> locks) {
        ArrayList<RFuture<Void>> futures = new ArrayList<RFuture<Void>>(locks.size());
        for (RLock rLock : locks) {
            futures.add(rLock.unlockAsync());
        }
        for (RFuture rFuture : futures) {
            rFuture.awaitUninterruptibly();
        }
    }

    @Override
    public boolean tryLock(long waitTime, TimeUnit unit) throws InterruptedException {
        return this.tryLock(waitTime, -1L, unit);
    }

    public boolean tryLock(long waitTime, long leaseTime, TimeUnit unit) throws InterruptedException {
        HashMap<RLock, RFuture<Boolean>> tryLockFutures = new HashMap<RLock, RFuture<Boolean>>(this.locks.size());
        for (RLock lock : this.locks) {
            tryLockFutures.put(lock, lock.tryLockAsync(waitTime, leaseTime, unit));
        }
        return this.sync(tryLockFutures);
    }

    @Override
    public void unlock() {
        ArrayList<RFuture<Void>> futures = new ArrayList<RFuture<Void>>(this.locks.size());
        for (RLock rLock : this.locks) {
            futures.add(rLock.unlockAsync());
        }
        for (RFuture rFuture : futures) {
            rFuture.syncUninterruptibly();
        }
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    protected boolean isLockFailed(Future<Boolean> future) {
        return !future.isSuccess();
    }

    protected boolean isAllLocksAcquired(AtomicReference<RLock> lockedLockHolder, AtomicReference<Throwable> failed, Queue<RLock> lockedLocks) {
        return lockedLockHolder.get() == null && failed.get() == null;
    }
}

