/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import org.reactivestreams.Subscriber;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClient;
import org.redisson.client.protocol.decoder.ListScanResult;
import reactor.rx.Stream;
import reactor.rx.subscription.ReactiveSubscription;

public abstract class SetReactiveIterator<V>
extends Stream<V> {
    @Override
    public void subscribe(Subscriber<? super V> t) {
        t.onSubscribe(new ReactiveSubscription<V>(this, t){
            private long nextIterPos;
            private RedisClient client;
            private boolean finished;

            @Override
            protected void onRequest(long n) {
                this.nextValues();
            }

            protected void nextValues() {
                final 1 m = this;
                SetReactiveIterator.this.scanIterator(this.client, this.nextIterPos).addListener(new FutureListener<ListScanResult<Object>>(){

                    @Override
                    public void operationComplete(Future<ListScanResult<Object>> future) throws Exception {
                        if (!future.isSuccess()) {
                            m.onError(future.cause());
                            return;
                        }
                        if (finished) {
                            client = null;
                            nextIterPos = 0L;
                            return;
                        }
                        ListScanResult<Object> res = future.getNow();
                        client = res.getRedisClient();
                        nextIterPos = res.getPos();
                        for (Object val : res.getValues()) {
                            m.onNext(val);
                        }
                        if (res.getPos() == 0L) {
                            finished = true;
                            m.onComplete();
                        }
                        if (finished) {
                            return;
                        }
                        this.nextValues();
                    }
                });
            }
        });
    }

    protected abstract RFuture<ListScanResult<Object>> scanIterator(RedisClient var1, long var2);
}

