/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.QueueSubscription;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.internal.util.QueueDrainHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowablePublishMulticast<T, R>
extends AbstractFlowableWithUpstream<T, R> {
    final Function<? super Flowable<T>, ? extends Publisher<? extends R>> selector;
    final int prefetch;
    final boolean delayError;

    public FlowablePublishMulticast(Flowable<T> source, Function<? super Flowable<T>, ? extends Publisher<? extends R>> selector, int prefetch, boolean delayError) {
        super(source);
        this.selector = selector;
        this.prefetch = prefetch;
        this.delayError = delayError;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s) {
        Publisher<R> other;
        MulticastProcessor mp = new MulticastProcessor(this.prefetch, this.delayError);
        try {
            other = ObjectHelper.requireNonNull(this.selector.apply(mp), "selector returned a null Publisher");
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            EmptySubscription.error(ex, s);
            return;
        }
        OutputCanceller<? super R> out = new OutputCanceller<R>(s, mp);
        other.subscribe(out);
        this.source.subscribe(mp);
    }

    static final class MulticastSubscription<T>
    extends AtomicLong
    implements Subscription {
        private static final long serialVersionUID = 8664815189257569791L;
        final Subscriber<? super T> actual;
        final MulticastProcessor<T> parent;
        long emitted;

        MulticastSubscription(Subscriber<? super T> actual, MulticastProcessor<T> parent) {
            this.actual = actual;
            this.parent = parent;
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.addCancel(this, n);
                this.parent.drain();
            }
        }

        @Override
        public void cancel() {
            if (this.getAndSet(Long.MIN_VALUE) != Long.MIN_VALUE) {
                this.parent.remove(this);
                this.parent.drain();
            }
        }

        public boolean isCancelled() {
            return this.get() == Long.MIN_VALUE;
        }
    }

    static final class MulticastProcessor<T>
    extends Flowable<T>
    implements FlowableSubscriber<T>,
    Disposable {
        static final MulticastSubscription[] EMPTY = new MulticastSubscription[0];
        static final MulticastSubscription[] TERMINATED = new MulticastSubscription[0];
        final AtomicInteger wip;
        final AtomicReference<MulticastSubscription<T>[]> subscribers;
        final int prefetch;
        final int limit;
        final boolean delayError;
        final AtomicReference<Subscription> s;
        volatile SimpleQueue<T> queue;
        int sourceMode;
        volatile boolean done;
        Throwable error;
        int consumed;

        MulticastProcessor(int prefetch, boolean delayError) {
            this.prefetch = prefetch;
            this.limit = prefetch - (prefetch >> 2);
            this.delayError = delayError;
            this.wip = new AtomicInteger();
            this.s = new AtomicReference();
            this.subscribers = new AtomicReference<MulticastSubscription[]>(EMPTY);
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.setOnce(this.s, s)) {
                if (s instanceof QueueSubscription) {
                    QueueSubscription qs = (QueueSubscription)s;
                    int m = qs.requestFusion(3);
                    if (m == 1) {
                        this.sourceMode = m;
                        this.queue = qs;
                        this.done = true;
                        this.drain();
                        return;
                    }
                    if (m == 2) {
                        this.sourceMode = m;
                        this.queue = qs;
                        QueueDrainHelper.request(s, this.prefetch);
                        return;
                    }
                }
                this.queue = QueueDrainHelper.createQueue(this.prefetch);
                QueueDrainHelper.request(s, this.prefetch);
            }
        }

        @Override
        public void dispose() {
            SimpleQueue<T> q;
            SubscriptionHelper.cancel(this.s);
            if (this.wip.getAndIncrement() == 0 && (q = this.queue) != null) {
                q.clear();
            }
        }

        @Override
        public boolean isDisposed() {
            return SubscriptionHelper.isCancelled(this.s.get());
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                return;
            }
            if (this.sourceMode == 0 && !this.queue.offer(t)) {
                this.s.get().cancel();
                this.onError(new MissingBackpressureException());
                return;
            }
            this.drain();
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.error = t;
            this.done = true;
            this.drain();
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.drain();
            }
        }

        boolean add(MulticastSubscription<T> s) {
            MulticastSubscription[] next;
            MulticastSubscription<T>[] current;
            do {
                if ((current = this.subscribers.get()) == TERMINATED) {
                    return false;
                }
                int n = current.length;
                next = new MulticastSubscription[n + 1];
                System.arraycopy(current, 0, next, 0, n);
                next[n] = s;
            } while (!this.subscribers.compareAndSet(current, next));
            return true;
        }

        void remove(MulticastSubscription<T> s) {
            MulticastSubscription[] next;
            MulticastSubscription<T>[] current;
            do {
                int n;
                if ((n = (current = this.subscribers.get()).length) == 0) {
                    return;
                }
                int j = -1;
                for (int i = 0; i < n; ++i) {
                    if (current[i] != s) continue;
                    j = i;
                    break;
                }
                if (j < 0) {
                    return;
                }
                if (n == 1) {
                    next = EMPTY;
                    continue;
                }
                next = new MulticastSubscription[n - 1];
                System.arraycopy(current, 0, next, 0, j);
                System.arraycopy(current, j + 1, next, j, n - j - 1);
            } while (!this.subscribers.compareAndSet(current, next));
        }

        @Override
        protected void subscribeActual(Subscriber<? super T> s) {
            MulticastSubscription<T> ms = new MulticastSubscription<T>(s, this);
            s.onSubscribe(ms);
            if (this.add(ms)) {
                if (ms.isCancelled()) {
                    this.remove(ms);
                    return;
                }
                this.drain();
            } else {
                Throwable ex = this.error;
                if (ex != null) {
                    s.onError(ex);
                } else {
                    s.onComplete();
                }
            }
        }

        void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            SimpleQueue<T> q = this.queue;
            int upstreamConsumed = this.consumed;
            int localLimit = this.limit;
            boolean canRequest = this.sourceMode != 1;
            AtomicReference<MulticastSubscription<T>[]> subs = this.subscribers;
            MulticastSubscription<T>[] array = subs.get();
            block2: while (true) {
                int n = array.length;
                if (q != null && n != 0) {
                    long r = Long.MAX_VALUE;
                    for (MulticastSubscription<T> ms : array) {
                        long u = ms.get() - ms.emitted;
                        if (u != Long.MIN_VALUE) {
                            if (r <= u) continue;
                            r = u;
                            continue;
                        }
                        --n;
                    }
                    if (n == 0) {
                        r = 0L;
                    }
                    while (r != 0L) {
                        boolean empty;
                        T v;
                        Throwable ex;
                        if (this.isDisposed()) {
                            q.clear();
                            return;
                        }
                        boolean d = this.done;
                        if (d && !this.delayError && (ex = this.error) != null) {
                            this.errorAll(ex);
                            return;
                        }
                        try {
                            v = q.poll();
                        }
                        catch (Throwable ex2) {
                            Exceptions.throwIfFatal(ex2);
                            SubscriptionHelper.cancel(this.s);
                            this.errorAll(ex2);
                            return;
                        }
                        boolean bl = empty = v == null;
                        if (d && empty) {
                            Throwable ex3 = this.error;
                            if (ex3 != null) {
                                this.errorAll(ex3);
                            } else {
                                this.completeAll();
                            }
                            return;
                        }
                        if (empty) break;
                        boolean subscribersChange = false;
                        for (MulticastSubscription<T> ms : array) {
                            long msr = ms.get();
                            if (msr != Long.MIN_VALUE) {
                                if (msr != Long.MAX_VALUE) {
                                    ++ms.emitted;
                                }
                                ms.actual.onNext(v);
                                continue;
                            }
                            subscribersChange = true;
                        }
                        --r;
                        if (canRequest && ++upstreamConsumed == localLimit) {
                            upstreamConsumed = 0;
                            this.s.get().request(localLimit);
                        }
                        MulticastSubscription<T>[] freshArray = subs.get();
                        if (!subscribersChange && freshArray == array) continue;
                        array = freshArray;
                        continue block2;
                    }
                    if (r == 0L) {
                        Throwable ex;
                        if (this.isDisposed()) {
                            q.clear();
                            return;
                        }
                        boolean d = this.done;
                        if (d && !this.delayError && (ex = this.error) != null) {
                            this.errorAll(ex);
                            return;
                        }
                        if (d && q.isEmpty()) {
                            ex = this.error;
                            if (ex != null) {
                                this.errorAll(ex);
                            } else {
                                this.completeAll();
                            }
                            return;
                        }
                    }
                }
                this.consumed = upstreamConsumed;
                if ((missed = this.wip.addAndGet(-missed)) == 0) break;
                if (q == null) {
                    q = this.queue;
                }
                array = subs.get();
            }
        }

        void errorAll(Throwable ex) {
            for (MulticastSubscription ms : this.subscribers.getAndSet(TERMINATED)) {
                if (ms.get() == Long.MIN_VALUE) continue;
                ms.actual.onError(ex);
            }
        }

        void completeAll() {
            for (MulticastSubscription ms : this.subscribers.getAndSet(TERMINATED)) {
                if (ms.get() == Long.MIN_VALUE) continue;
                ms.actual.onComplete();
            }
        }
    }

    static final class OutputCanceller<R>
    implements FlowableSubscriber<R>,
    Subscription {
        final Subscriber<? super R> actual;
        final MulticastProcessor<?> processor;
        Subscription s;

        OutputCanceller(Subscriber<? super R> actual, MulticastProcessor<?> processor) {
            this.actual = actual;
            this.processor = processor;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(R t) {
            this.actual.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            this.actual.onError(t);
            this.processor.dispose();
        }

        @Override
        public void onComplete() {
            this.actual.onComplete();
            this.processor.dispose();
        }

        @Override
        public void request(long n) {
            this.s.request(n);
        }

        @Override
        public void cancel() {
            this.s.cancel();
            this.processor.dispose();
        }
    }
}

