/*
 * Decompiled with CFR 0.152.
 */
package reactor.jarjar.com.lmax.disruptor;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import reactor.jarjar.com.lmax.disruptor.DataProvider;
import reactor.jarjar.com.lmax.disruptor.EventPoller;
import reactor.jarjar.com.lmax.disruptor.ProcessingSequenceBarrier;
import reactor.jarjar.com.lmax.disruptor.Sequence;
import reactor.jarjar.com.lmax.disruptor.SequenceBarrier;
import reactor.jarjar.com.lmax.disruptor.SequenceGroups;
import reactor.jarjar.com.lmax.disruptor.Sequencer;
import reactor.jarjar.com.lmax.disruptor.WaitStrategy;
import reactor.jarjar.com.lmax.disruptor.util.Util;

public abstract class AbstractSequencer
implements Sequencer {
    private static final AtomicReferenceFieldUpdater<AbstractSequencer, Sequence[]> SEQUENCE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(AbstractSequencer.class, Sequence[].class, "gatingSequences");
    protected final int bufferSize;
    protected final WaitStrategy waitStrategy;
    protected final Sequence cursor = new Sequence(-1L);
    protected volatile Sequence[] gatingSequences = new Sequence[0];

    public AbstractSequencer(int bufferSize, WaitStrategy waitStrategy) {
        if (bufferSize < 1) {
            throw new IllegalArgumentException("bufferSize must not be less than 1");
        }
        if (Integer.bitCount(bufferSize) != 1) {
            throw new IllegalArgumentException("bufferSize must be a power of 2");
        }
        this.bufferSize = bufferSize;
        this.waitStrategy = waitStrategy;
    }

    @Override
    public final long getCursor() {
        return this.cursor.get();
    }

    @Override
    public final int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public final void addGatingSequences(Sequence ... gatingSequences) {
        SequenceGroups.addSequences(this, SEQUENCE_UPDATER, this, gatingSequences);
    }

    @Override
    public boolean removeGatingSequence(Sequence sequence) {
        return SequenceGroups.removeSequence(this, SEQUENCE_UPDATER, sequence);
    }

    @Override
    public long getMinimumSequence() {
        return Util.getMinimumSequence(this.gatingSequences, this.cursor.get());
    }

    @Override
    public SequenceBarrier newBarrier(Sequence ... sequencesToTrack) {
        return new ProcessingSequenceBarrier(this, this.waitStrategy, this.cursor, sequencesToTrack);
    }

    @Override
    public <T> EventPoller<T> newPoller(DataProvider<T> dataProvider, Sequence ... gatingSequences) {
        return EventPoller.newInstance(dataProvider, this, new Sequence(), this.cursor, gatingSequences);
    }
}

