/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.Map;
import org.reactivestreams.Publisher;
import org.redisson.RedissonMap;
import org.redisson.api.RMapCache;
import org.redisson.reactive.MapReactiveIterator;

public class RedissonMapCacheReactive<K, V> {
    private final RMapCache<K, V> mapCache;

    public RedissonMapCacheReactive(RMapCache<K, V> mapCache) {
        this.mapCache = mapCache;
    }

    public Publisher<Map.Entry<K, V>> entryIterator() {
        return this.entryIterator(null);
    }

    public Publisher<Map.Entry<K, V>> entryIterator(int count) {
        return this.entryIterator(null, count);
    }

    public Publisher<Map.Entry<K, V>> entryIterator(String pattern) {
        return this.entryIterator(pattern, 10);
    }

    public Publisher<Map.Entry<K, V>> entryIterator(String pattern, int count) {
        return new MapReactiveIterator((RedissonMap)((Object)this.mapCache), pattern, count).stream();
    }

    public Publisher<V> valueIterator() {
        return this.valueIterator(null);
    }

    public Publisher<V> valueIterator(String pattern) {
        return this.valueIterator(pattern, 10);
    }

    public Publisher<V> valueIterator(int count) {
        return this.valueIterator(null, count);
    }

    public Publisher<V> valueIterator(String pattern, int count) {
        return new MapReactiveIterator<K, V, V>((RedissonMap)((Object)this.mapCache), pattern, count){

            @Override
            V getValue(Map.Entry<Object, Object> entry) {
                return entry.getValue();
            }
        }.stream();
    }

    public Publisher<K> keyIterator() {
        return this.keyIterator(null);
    }

    public Publisher<K> keyIterator(String pattern) {
        return this.keyIterator(pattern, 10);
    }

    public Publisher<K> keyIterator(int count) {
        return this.keyIterator(null, count);
    }

    public Publisher<K> keyIterator(String pattern, int count) {
        return new MapReactiveIterator<K, V, K>((RedissonMap)((Object)this.mapCache), pattern, count){

            @Override
            K getValue(Map.Entry<Object, Object> entry) {
                return entry.getKey();
            }
        }.stream();
    }
}

