/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.buffer.ByteBuf;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.redisson.PubSubMessageListener;
import org.redisson.PubSubStatusListener;
import org.redisson.RedissonReference;
import org.redisson.api.RFuture;
import org.redisson.api.RTopic;
import org.redisson.api.listener.MessageListener;
import org.redisson.api.listener.StatusListener;
import org.redisson.client.ChannelName;
import org.redisson.client.RedisPubSubListener;
import org.redisson.client.RedisTimeoutException;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.misc.RedissonPromise;
import org.redisson.misc.TransferListener;
import org.redisson.pubsub.AsyncSemaphore;
import org.redisson.pubsub.PubSubConnectionEntry;
import org.redisson.pubsub.PublishSubscribeService;

public class RedissonTopic
implements RTopic {
    final PublishSubscribeService subscribeService;
    final CommandAsyncExecutor commandExecutor;
    private final String name;
    private final ChannelName channelName;
    private final Codec codec;

    public RedissonTopic(CommandAsyncExecutor commandExecutor, String name) {
        this(commandExecutor.getConnectionManager().getCodec(), commandExecutor, name);
    }

    public RedissonTopic(Codec codec, CommandAsyncExecutor commandExecutor, String name) {
        this.commandExecutor = commandExecutor;
        this.name = name;
        this.channelName = new ChannelName(name);
        this.codec = codec;
        this.subscribeService = commandExecutor.getConnectionManager().getSubscribeService();
    }

    @Override
    public List<String> getChannelNames() {
        return Collections.singletonList(this.name);
    }

    @Override
    public long publish(Object message) {
        return this.commandExecutor.get(this.publishAsync(message));
    }

    @Override
    public RFuture<Long> publishAsync(Object message) {
        return this.commandExecutor.writeAsync(this.name, (Codec)StringCodec.INSTANCE, RedisCommands.PUBLISH, this.name, this.encode(message));
    }

    protected ByteBuf encode(Object value) {
        RedissonReference reference;
        if (this.commandExecutor.isRedissonReferenceSupportEnabled() && (reference = this.commandExecutor.getObjectBuilder().toReference(value)) != null) {
            value = reference;
        }
        try {
            return this.codec.getValueEncoder().encode(value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public int addListener(StatusListener listener) {
        return this.addListener(new PubSubStatusListener(listener, this.name));
    }

    @Override
    public <M> int addListener(Class<M> type, MessageListener<? extends M> listener) {
        PubSubMessageListener<? extends M> pubSubListener = new PubSubMessageListener<M>(type, listener, this.name);
        return this.addListener(pubSubListener);
    }

    @Override
    public RFuture<Integer> addListenerAsync(StatusListener listener) {
        PubSubStatusListener pubSubListener = new PubSubStatusListener(listener, this.name);
        return this.addListenerAsync(pubSubListener);
    }

    @Override
    public <M> RFuture<Integer> addListenerAsync(Class<M> type, MessageListener<M> listener) {
        PubSubMessageListener<M> pubSubListener = new PubSubMessageListener<M>(type, listener, this.name);
        return this.addListenerAsync(pubSubListener);
    }

    private int addListener(RedisPubSubListener<?> pubSubListener) {
        RFuture<PubSubConnectionEntry> future = this.subscribeService.subscribe(this.codec, this.channelName, pubSubListener);
        this.commandExecutor.syncSubscription(future);
        return System.identityHashCode(pubSubListener);
    }

    private RFuture<Integer> addListenerAsync(final RedisPubSubListener<?> pubSubListener) {
        RFuture<PubSubConnectionEntry> future = this.subscribeService.subscribe(this.codec, this.channelName, pubSubListener);
        final RedissonPromise<Integer> result = new RedissonPromise<Integer>();
        future.addListener(new FutureListener<PubSubConnectionEntry>(){

            @Override
            public void operationComplete(Future<PubSubConnectionEntry> future) throws Exception {
                if (!future.isSuccess()) {
                    result.tryFailure(future.cause());
                    return;
                }
                result.trySuccess(System.identityHashCode(pubSubListener));
            }
        });
        return result;
    }

    @Override
    public void removeAllListeners() {
        AsyncSemaphore semaphore = this.subscribeService.getSemaphore(this.channelName);
        this.acquire(semaphore);
        PubSubConnectionEntry entry = this.subscribeService.getPubSubEntry(this.channelName);
        if (entry == null) {
            semaphore.release();
            return;
        }
        if (entry.removeAllListeners(this.channelName)) {
            this.subscribeService.unsubscribe(this.channelName, semaphore).syncUninterruptibly();
        } else {
            semaphore.release();
        }
    }

    protected void acquire(AsyncSemaphore semaphore) {
        MasterSlaveServersConfig config = this.commandExecutor.getConnectionManager().getConfig();
        int timeout = config.getTimeout() + config.getRetryInterval() * config.getRetryAttempts();
        if (!semaphore.tryAcquire(timeout)) {
            throw new RedisTimeoutException("Remove listeners operation timeout: (" + timeout + "ms) for " + this.name + " topic");
        }
    }

    @Override
    public void removeListener(MessageListener<?> listener) {
        AsyncSemaphore semaphore = this.subscribeService.getSemaphore(this.channelName);
        this.acquire(semaphore);
        PubSubConnectionEntry entry = this.subscribeService.getPubSubEntry(this.channelName);
        if (entry == null) {
            semaphore.release();
            return;
        }
        entry.removeListener(this.channelName, listener);
        if (!entry.hasListeners(this.channelName)) {
            this.subscribeService.unsubscribe(this.channelName, semaphore);
        } else {
            semaphore.release();
        }
    }

    @Override
    public RFuture<Void> removeListenerAsync(final MessageListener<?> listener) {
        final RedissonPromise<Void> promise = new RedissonPromise<Void>();
        final AsyncSemaphore semaphore = this.subscribeService.getSemaphore(this.channelName);
        semaphore.acquire(new Runnable(){

            @Override
            public void run() {
                PubSubConnectionEntry entry = RedissonTopic.this.subscribeService.getPubSubEntry(RedissonTopic.this.channelName);
                if (entry == null) {
                    semaphore.release();
                    promise.trySuccess(null);
                    return;
                }
                entry.removeListener(RedissonTopic.this.channelName, listener);
                if (!entry.hasListeners(RedissonTopic.this.channelName)) {
                    RedissonTopic.this.subscribeService.unsubscribe(RedissonTopic.this.channelName, semaphore).addListener(new TransferListener(promise));
                } else {
                    semaphore.release();
                    promise.trySuccess(null);
                }
            }
        });
        return promise;
    }

    @Override
    public RFuture<Void> removeListenerAsync(final int listenerId) {
        final RedissonPromise<Void> promise = new RedissonPromise<Void>();
        final AsyncSemaphore semaphore = this.subscribeService.getSemaphore(this.channelName);
        semaphore.acquire(new Runnable(){

            @Override
            public void run() {
                PubSubConnectionEntry entry = RedissonTopic.this.subscribeService.getPubSubEntry(RedissonTopic.this.channelName);
                if (entry == null) {
                    semaphore.release();
                    promise.trySuccess(null);
                    return;
                }
                entry.removeListener(RedissonTopic.this.channelName, listenerId);
                if (!entry.hasListeners(RedissonTopic.this.channelName)) {
                    RedissonTopic.this.subscribeService.unsubscribe(RedissonTopic.this.channelName, semaphore).addListener(new TransferListener(promise));
                } else {
                    semaphore.release();
                    promise.trySuccess(null);
                }
            }
        });
        return promise;
    }

    @Override
    public void removeListener(int listenerId) {
        AsyncSemaphore semaphore = this.subscribeService.getSemaphore(this.channelName);
        this.acquire(semaphore);
        PubSubConnectionEntry entry = this.subscribeService.getPubSubEntry(this.channelName);
        if (entry == null) {
            semaphore.release();
            return;
        }
        entry.removeListener(this.channelName, listenerId);
        if (!entry.hasListeners(this.channelName)) {
            this.subscribeService.unsubscribe(this.channelName, semaphore).syncUninterruptibly();
        } else {
            semaphore.release();
        }
    }

    @Override
    public int countListeners() {
        PubSubConnectionEntry entry = this.subscribeService.getPubSubEntry(this.channelName);
        if (entry != null) {
            return entry.countListeners();
        }
        return 0;
    }

    @Override
    public RFuture<Long> countSubscribersAsync() {
        return this.commandExecutor.writeAsync(this.name, (Codec)LongCodec.INSTANCE, RedisCommands.PUBSUB_NUMSUB, this.name);
    }

    @Override
    public long countSubscribers() {
        return this.commandExecutor.get(this.countSubscribersAsync());
    }
}

