/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.config;

import io.netty.channel.EventLoopGroup;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import org.redisson.client.codec.Codec;
import org.redisson.codec.DefaultReferenceCodecProvider;
import org.redisson.codec.FstCodec;
import org.redisson.codec.ReferenceCodecProvider;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.ConfigSupport;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.ReplicatedServersConfig;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.redisson.config.TransportMode;
import org.redisson.connection.AddressResolverGroupFactory;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MultiDnsAddressResolverGroupFactory;
import org.redisson.misc.URIBuilder;

public class Config {
    private SentinelServersConfig sentinelServersConfig;
    private MasterSlaveServersConfig masterSlaveServersConfig;
    private SingleServerConfig singleServerConfig;
    private ClusterServersConfig clusterServersConfig;
    private ReplicatedServersConfig replicatedServersConfig;
    private ConnectionManager connectionManager;
    private int threads = 0;
    private int nettyThreads = 0;
    private Codec codec;
    private ReferenceCodecProvider referenceCodecProvider = new DefaultReferenceCodecProvider();
    private ExecutorService executor;
    private boolean referenceEnabled = true;
    private TransportMode transportMode = TransportMode.NIO;
    private EventLoopGroup eventLoopGroup;
    private long lockWatchdogTimeout = 30000L;
    private boolean keepPubSubOrder = true;
    private boolean useScriptCache = false;
    private AddressResolverGroupFactory addressResolverGroupFactory = new MultiDnsAddressResolverGroupFactory();

    public Config() {
    }

    public Config(Config oldConf) {
        this.setExecutor(oldConf.getExecutor());
        if (oldConf.getCodec() == null) {
            oldConf.setCodec(new FstCodec());
        }
        this.setUseScriptCache(oldConf.isUseScriptCache());
        this.setKeepPubSubOrder(oldConf.isKeepPubSubOrder());
        this.setLockWatchdogTimeout(oldConf.getLockWatchdogTimeout());
        this.setNettyThreads(oldConf.getNettyThreads());
        this.setThreads(oldConf.getThreads());
        this.setCodec(oldConf.getCodec());
        this.setReferenceCodecProvider(oldConf.getReferenceCodecProvider());
        this.setReferenceEnabled(oldConf.isReferenceEnabled());
        this.setEventLoopGroup(oldConf.getEventLoopGroup());
        this.setTransportMode(oldConf.getTransportMode());
        this.setAddressResolverGroupFactory(oldConf.getAddressResolverGroupFactory());
        if (oldConf.getSingleServerConfig() != null) {
            this.setSingleServerConfig(new SingleServerConfig(oldConf.getSingleServerConfig()));
        }
        if (oldConf.getMasterSlaveServersConfig() != null) {
            this.setMasterSlaveServersConfig(new MasterSlaveServersConfig(oldConf.getMasterSlaveServersConfig()));
        }
        if (oldConf.getSentinelServersConfig() != null) {
            this.setSentinelServersConfig(new SentinelServersConfig(oldConf.getSentinelServersConfig()));
        }
        if (oldConf.getClusterServersConfig() != null) {
            this.setClusterServersConfig(new ClusterServersConfig(oldConf.getClusterServersConfig()));
        }
        if (oldConf.getReplicatedServersConfig() != null) {
            this.setReplicatedServersConfig(new ReplicatedServersConfig(oldConf.getReplicatedServersConfig()));
        }
        if (oldConf.getConnectionManager() != null) {
            this.useCustomServers(oldConf.getConnectionManager());
        }
    }

    public Config setCodec(Codec codec) {
        this.codec = codec;
        return this;
    }

    public Codec getCodec() {
        return this.codec;
    }

    public Config setReferenceCodecProvider(ReferenceCodecProvider codecProvider) {
        this.referenceCodecProvider = codecProvider;
        return this;
    }

    public ReferenceCodecProvider getReferenceCodecProvider() {
        return this.referenceCodecProvider;
    }

    public boolean isReferenceEnabled() {
        return this.referenceEnabled;
    }

    public void setReferenceEnabled(boolean redissonReferenceEnabled) {
        this.referenceEnabled = redissonReferenceEnabled;
    }

    public ClusterServersConfig useClusterServers() {
        return this.useClusterServers(new ClusterServersConfig());
    }

    ClusterServersConfig useClusterServers(ClusterServersConfig config) {
        this.checkMasterSlaveServersConfig();
        this.checkSentinelServersConfig();
        this.checkSingleServerConfig();
        this.checkReplicatedServersConfig();
        if (this.clusterServersConfig == null) {
            this.clusterServersConfig = config;
        }
        return this.clusterServersConfig;
    }

    ClusterServersConfig getClusterServersConfig() {
        return this.clusterServersConfig;
    }

    void setClusterServersConfig(ClusterServersConfig clusterServersConfig) {
        this.clusterServersConfig = clusterServersConfig;
    }

    public ReplicatedServersConfig useReplicatedServers() {
        return this.useReplicatedServers(new ReplicatedServersConfig());
    }

    ReplicatedServersConfig useReplicatedServers(ReplicatedServersConfig config) {
        this.checkClusterServersConfig();
        this.checkMasterSlaveServersConfig();
        this.checkSentinelServersConfig();
        this.checkSingleServerConfig();
        if (this.replicatedServersConfig == null) {
            this.replicatedServersConfig = new ReplicatedServersConfig();
        }
        return this.replicatedServersConfig;
    }

    ReplicatedServersConfig getReplicatedServersConfig() {
        return this.replicatedServersConfig;
    }

    void setReplicatedServersConfig(ReplicatedServersConfig replicatedServersConfig) {
        this.replicatedServersConfig = replicatedServersConfig;
    }

    ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public void useCustomServers(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public SingleServerConfig useSingleServer() {
        return this.useSingleServer(new SingleServerConfig());
    }

    SingleServerConfig useSingleServer(SingleServerConfig config) {
        this.checkClusterServersConfig();
        this.checkMasterSlaveServersConfig();
        this.checkSentinelServersConfig();
        this.checkReplicatedServersConfig();
        if (this.singleServerConfig == null) {
            this.singleServerConfig = config;
        }
        return this.singleServerConfig;
    }

    SingleServerConfig getSingleServerConfig() {
        return this.singleServerConfig;
    }

    void setSingleServerConfig(SingleServerConfig singleConnectionConfig) {
        this.singleServerConfig = singleConnectionConfig;
    }

    public SentinelServersConfig useSentinelServers() {
        return this.useSentinelServers(new SentinelServersConfig());
    }

    SentinelServersConfig useSentinelServers(SentinelServersConfig sentinelServersConfig) {
        this.checkClusterServersConfig();
        this.checkSingleServerConfig();
        this.checkMasterSlaveServersConfig();
        this.checkReplicatedServersConfig();
        if (this.sentinelServersConfig == null) {
            this.sentinelServersConfig = sentinelServersConfig;
        }
        return this.sentinelServersConfig;
    }

    SentinelServersConfig getSentinelServersConfig() {
        return this.sentinelServersConfig;
    }

    void setSentinelServersConfig(SentinelServersConfig sentinelConnectionConfig) {
        this.sentinelServersConfig = sentinelConnectionConfig;
    }

    public MasterSlaveServersConfig useMasterSlaveServers() {
        return this.useMasterSlaveServers(new MasterSlaveServersConfig());
    }

    MasterSlaveServersConfig useMasterSlaveServers(MasterSlaveServersConfig config) {
        this.checkClusterServersConfig();
        this.checkSingleServerConfig();
        this.checkSentinelServersConfig();
        this.checkReplicatedServersConfig();
        if (this.masterSlaveServersConfig == null) {
            this.masterSlaveServersConfig = config;
        }
        return this.masterSlaveServersConfig;
    }

    MasterSlaveServersConfig getMasterSlaveServersConfig() {
        return this.masterSlaveServersConfig;
    }

    void setMasterSlaveServersConfig(MasterSlaveServersConfig masterSlaveConnectionConfig) {
        this.masterSlaveServersConfig = masterSlaveConnectionConfig;
    }

    public boolean isClusterConfig() {
        return this.clusterServersConfig != null;
    }

    public boolean isSentinelConfig() {
        return this.sentinelServersConfig != null;
    }

    public int getThreads() {
        return this.threads;
    }

    public Config setThreads(int threads) {
        this.threads = threads;
        return this;
    }

    private void checkClusterServersConfig() {
        if (this.clusterServersConfig != null) {
            throw new IllegalStateException("cluster servers config already used!");
        }
    }

    private void checkSentinelServersConfig() {
        if (this.sentinelServersConfig != null) {
            throw new IllegalStateException("sentinel servers config already used!");
        }
    }

    private void checkMasterSlaveServersConfig() {
        if (this.masterSlaveServersConfig != null) {
            throw new IllegalStateException("master/slave servers already used!");
        }
    }

    private void checkSingleServerConfig() {
        if (this.singleServerConfig != null) {
            throw new IllegalStateException("single server config already used!");
        }
    }

    private void checkReplicatedServersConfig() {
        if (this.replicatedServersConfig != null) {
            throw new IllegalStateException("Replication servers config already used!");
        }
    }

    public Config setTransportMode(TransportMode transportMode) {
        this.transportMode = transportMode;
        return this;
    }

    public TransportMode getTransportMode() {
        return this.transportMode;
    }

    public Config setNettyThreads(int nettyThreads) {
        this.nettyThreads = nettyThreads;
        return this;
    }

    public int getNettyThreads() {
        return this.nettyThreads;
    }

    public Config setExecutor(ExecutorService executor) {
        this.executor = executor;
        return this;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public Config setEventLoopGroup(EventLoopGroup eventLoopGroup) {
        this.eventLoopGroup = eventLoopGroup;
        return this;
    }

    public EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    public Config setLockWatchdogTimeout(long lockWatchdogTimeout) {
        this.lockWatchdogTimeout = lockWatchdogTimeout;
        return this;
    }

    public long getLockWatchdogTimeout() {
        return this.lockWatchdogTimeout;
    }

    public Config setKeepPubSubOrder(boolean keepPubSubOrder) {
        this.keepPubSubOrder = keepPubSubOrder;
        return this;
    }

    public boolean isKeepPubSubOrder() {
        return this.keepPubSubOrder;
    }

    public Config setAddressResolverGroupFactory(AddressResolverGroupFactory addressResolverGroupFactory) {
        this.addressResolverGroupFactory = addressResolverGroupFactory;
        return this;
    }

    public AddressResolverGroupFactory getAddressResolverGroupFactory() {
        return this.addressResolverGroupFactory;
    }

    public static Config fromJSON(String content) throws IOException {
        ConfigSupport support = new ConfigSupport();
        return support.fromJSON(content, Config.class);
    }

    public static Config fromJSON(InputStream inputStream) throws IOException {
        ConfigSupport support = new ConfigSupport();
        return support.fromJSON(inputStream, Config.class);
    }

    public static Config fromJSON(File file, ClassLoader classLoader) throws IOException {
        ConfigSupport support = new ConfigSupport();
        return support.fromJSON(file, Config.class, classLoader);
    }

    public static Config fromJSON(File file) throws IOException {
        return Config.fromJSON(file, null);
    }

    public static Config fromJSON(URL url) throws IOException {
        ConfigSupport support = new ConfigSupport();
        return support.fromJSON(url, Config.class);
    }

    public static Config fromJSON(Reader reader) throws IOException {
        ConfigSupport support = new ConfigSupport();
        return support.fromJSON(reader, Config.class);
    }

    public String toJSON() throws IOException {
        ConfigSupport support = new ConfigSupport();
        return support.toJSON(this);
    }

    public static Config fromYAML(String content) throws IOException {
        ConfigSupport support = new ConfigSupport();
        return support.fromYAML(content, Config.class);
    }

    public static Config fromYAML(InputStream inputStream) throws IOException {
        ConfigSupport support = new ConfigSupport();
        return support.fromYAML(inputStream, Config.class);
    }

    public static Config fromYAML(File file) throws IOException {
        return Config.fromYAML(file, null);
    }

    public static Config fromYAML(File file, ClassLoader classLoader) throws IOException {
        ConfigSupport support = new ConfigSupport();
        return support.fromYAML(file, Config.class, classLoader);
    }

    public static Config fromYAML(URL url) throws IOException {
        ConfigSupport support = new ConfigSupport();
        return support.fromYAML(url, Config.class);
    }

    public static Config fromYAML(Reader reader) throws IOException {
        ConfigSupport support = new ConfigSupport();
        return support.fromYAML(reader, Config.class);
    }

    public String toYAML() throws IOException {
        ConfigSupport support = new ConfigSupport();
        return support.toYAML(this);
    }

    public Config setUseScriptCache(boolean useScriptCache) {
        this.useScriptCache = useScriptCache;
        return this;
    }

    public boolean isUseScriptCache() {
        return this.useScriptCache;
    }

    static {
        URIBuilder.patchUriObject();
    }
}

