/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.io.Serializable;
import org.redisson.api.RAtomicLong;
import org.redisson.api.RAtomicLongReactive;
import org.redisson.api.RBitSet;
import org.redisson.api.RBitSetReactive;
import org.redisson.api.RBlockingQueue;
import org.redisson.api.RBlockingQueueReactive;
import org.redisson.api.RBucket;
import org.redisson.api.RBucketReactive;
import org.redisson.api.RDeque;
import org.redisson.api.RDequeReactive;
import org.redisson.api.RHyperLogLog;
import org.redisson.api.RHyperLogLogReactive;
import org.redisson.api.RLexSortedSet;
import org.redisson.api.RLexSortedSetReactive;
import org.redisson.api.RList;
import org.redisson.api.RListReactive;
import org.redisson.api.RMap;
import org.redisson.api.RMapCache;
import org.redisson.api.RMapCacheReactive;
import org.redisson.api.RMapReactive;
import org.redisson.api.RObject;
import org.redisson.api.RObjectReactive;
import org.redisson.api.RQueue;
import org.redisson.api.RQueueReactive;
import org.redisson.api.RScoredSortedSet;
import org.redisson.api.RScoredSortedSetReactive;
import org.redisson.api.RSet;
import org.redisson.api.RSetCache;
import org.redisson.api.RSetCacheReactive;
import org.redisson.api.RSetReactive;
import org.redisson.api.annotation.REntity;
import org.redisson.client.codec.Codec;
import org.redisson.liveobject.misc.ClassUtils;
import org.redisson.misc.BiHashMap;

public class RedissonReference
implements Serializable {
    private static final BiHashMap<String, String> reactiveMap = new BiHashMap();
    private String type;
    private String keyName;
    private String codec;

    public static void warmUp() {
    }

    public RedissonReference() {
    }

    public RedissonReference(Class<?> type, String keyName) {
        this(type, keyName, null);
    }

    public RedissonReference(Class<?> type, String keyName, Codec codec) {
        if (!(ClassUtils.isAnnotationPresent(type, REntity.class) || RObject.class.isAssignableFrom(type) || RObjectReactive.class.isAssignableFrom(type))) {
            throw new IllegalArgumentException("Class reference has to be a type of either RObject or RLiveObject or RObjectReactive");
        }
        this.type = RObjectReactive.class.isAssignableFrom(type) ? reactiveMap.get(type.getName()) : type.getName();
        this.keyName = keyName;
        this.codec = codec != null ? codec.getClass().getName() : null;
    }

    public Class<?> getType() throws Exception {
        return Class.forName(this.type);
    }

    public Class<?> getReactiveType() throws Exception {
        if (reactiveMap.containsValue(this.type)) {
            return Class.forName(reactiveMap.reverseGet(this.type));
        }
        throw new ClassNotFoundException("There is no Reactive compatible type for " + this.type);
    }

    public String getTypeName() {
        return this.type;
    }

    public String getReactiveTypeName() {
        return this.type + "Reactive";
    }

    public void setType(Class<?> type) {
        if (!(ClassUtils.isAnnotationPresent(type, REntity.class) || RObject.class.isAssignableFrom(type) && RObjectReactive.class.isAssignableFrom(type))) {
            throw new IllegalArgumentException("Class reference has to be a type of either RObject or RLiveObject or RObjectReactive");
        }
        this.type = type.getName();
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public String getCodec() {
        return this.codec;
    }

    public Class<? extends Codec> getCodecType() throws Exception {
        return this.codec == null ? null : Class.forName(this.codec);
    }

    public String getCodecName() {
        return this.codec;
    }

    public void setCodecType(Class<? extends Codec> codec) {
        this.codec = codec.getName();
    }

    static {
        reactiveMap.put(RAtomicLongReactive.class.getName(), RAtomicLong.class.getName());
        reactiveMap.put(RBitSetReactive.class.getName(), RBitSet.class.getName());
        reactiveMap.put(RBlockingQueueReactive.class.getName(), RBlockingQueue.class.getName());
        reactiveMap.put(RBucketReactive.class.getName(), RBucket.class.getName());
        reactiveMap.put(RDequeReactive.class.getName(), RDeque.class.getName());
        reactiveMap.put(RHyperLogLogReactive.class.getName(), RHyperLogLog.class.getName());
        reactiveMap.put(RLexSortedSetReactive.class.getName(), RLexSortedSet.class.getName());
        reactiveMap.put(RListReactive.class.getName(), RList.class.getName());
        reactiveMap.put(RMapCacheReactive.class.getName(), RMapCache.class.getName());
        reactiveMap.put(RMapReactive.class.getName(), RMap.class.getName());
        reactiveMap.put(RQueueReactive.class.getName(), RQueue.class.getName());
        reactiveMap.put(RScoredSortedSetReactive.class.getName(), RScoredSortedSet.class.getName());
        reactiveMap.put(RSetCacheReactive.class.getName(), RSetCache.class.getName());
        reactiveMap.put(RSetReactive.class.getName(), RSet.class.getName());
        reactiveMap.makeImmutable();
    }
}

