/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonPriorityBlockingQueue;
import org.redisson.RedissonPriorityDeque;
import org.redisson.api.RFuture;
import org.redisson.api.RPriorityBlockingDeque;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandExecutor;
import org.redisson.misc.RedissonPromise;

public class RedissonPriorityBlockingDeque<V>
extends RedissonPriorityDeque<V>
implements RPriorityBlockingDeque<V> {
    private final RedissonPriorityBlockingQueue<V> blockingQueue;

    protected RedissonPriorityBlockingDeque(CommandExecutor commandExecutor, String name, RedissonClient redisson) {
        super(commandExecutor, name, redisson);
        this.blockingQueue = (RedissonPriorityBlockingQueue)redisson.getPriorityBlockingQueue(name);
    }

    protected RedissonPriorityBlockingDeque(Codec codec, CommandExecutor commandExecutor, String name, RedissonClient redisson) {
        super(codec, commandExecutor, name, redisson);
        this.blockingQueue = (RedissonPriorityBlockingQueue)redisson.getPriorityBlockingQueue(name, codec);
    }

    @Override
    public void put(V e) throws InterruptedException {
        this.add(e);
    }

    @Override
    public boolean offer(V e, long timeout, TimeUnit unit) throws InterruptedException {
        return this.offer(e);
    }

    @Override
    public RFuture<V> takeAsync() {
        return this.blockingQueue.takeAsync();
    }

    @Override
    public V take() throws InterruptedException {
        return this.blockingQueue.take();
    }

    @Override
    public RFuture<V> pollAsync(long timeout, TimeUnit unit) {
        return this.blockingQueue.pollAsync(timeout, unit);
    }

    @Override
    public V poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.blockingQueue.poll(timeout, unit);
    }

    @Override
    public V pollFromAny(long timeout, TimeUnit unit, String ... queueNames) throws InterruptedException {
        throw new UnsupportedOperationException("use poll method");
    }

    @Override
    public RFuture<V> pollLastAndOfferFirstToAsync(String queueName, long timeout, TimeUnit unit) {
        return this.blockingQueue.pollLastAndOfferFirstToAsync(queueName, timeout, unit);
    }

    @Override
    public V pollLastAndOfferFirstTo(String queueName, long timeout, TimeUnit unit) throws InterruptedException {
        return this.blockingQueue.pollLastAndOfferFirstTo(queueName, timeout, unit);
    }

    @Override
    public V takeLastAndOfferFirstTo(String queueName) throws InterruptedException {
        return this.get(this.takeLastAndOfferFirstToAsync(queueName));
    }

    @Override
    public RFuture<V> takeLastAndOfferFirstToAsync(String queueName) {
        return this.pollLastAndOfferFirstToAsync(queueName, 0L, TimeUnit.SECONDS);
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int drainTo(Collection<? super V> c) {
        return this.blockingQueue.drainTo(c);
    }

    @Override
    public RFuture<Integer> drainToAsync(Collection<? super V> c) {
        return this.blockingQueue.drainToAsync(c);
    }

    @Override
    public int drainTo(Collection<? super V> c, int maxElements) {
        return this.blockingQueue.drainTo(c, maxElements);
    }

    @Override
    public RFuture<Integer> drainToAsync(Collection<? super V> c, int maxElements) {
        return this.blockingQueue.drainToAsync(c, maxElements);
    }

    @Override
    public RFuture<Boolean> offerAsync(V e) {
        throw new UnsupportedOperationException("use offer method");
    }

    @Override
    public RFuture<V> pollFromAnyAsync(long timeout, TimeUnit unit, String ... queueNames) {
        throw new UnsupportedOperationException("use poll method");
    }

    @Override
    public RFuture<Void> putAsync(V e) {
        throw new UnsupportedOperationException("use add method");
    }

    @Override
    public RFuture<Void> putFirstAsync(V e) {
        return this.addFirstAsync(e);
    }

    @Override
    public RFuture<Void> putLastAsync(V e) {
        return this.addLastAsync(e);
    }

    @Override
    public void putFirst(V e) throws InterruptedException {
        this.addFirst(e);
    }

    @Override
    public void putLast(V e) throws InterruptedException {
        this.addLast(e);
    }

    @Override
    public boolean offerFirst(V e, long timeout, TimeUnit unit) throws InterruptedException {
        this.addFirst(e);
        return true;
    }

    @Override
    public boolean offerLast(V e, long timeout, TimeUnit unit) throws InterruptedException {
        this.addLast(e);
        return true;
    }

    @Override
    public V takeFirst() throws InterruptedException {
        return this.get(this.takeFirstAsync());
    }

    @Override
    public RFuture<V> takeFirstAsync() {
        return this.takeAsync();
    }

    @Override
    public RFuture<V> takeLastAsync() {
        RedissonPromise result = new RedissonPromise();
        this.blockingQueue.takeAsync(result, 0L, 0L, RedisCommands.RPOP, this.getName());
        return result;
    }

    @Override
    public V takeLast() throws InterruptedException {
        return this.get(this.takeLastAsync());
    }

    @Override
    public RFuture<V> pollFirstAsync(long timeout, TimeUnit unit) {
        return this.pollAsync(timeout, unit);
    }

    @Override
    public V pollFirstFromAny(long timeout, TimeUnit unit, String ... queueNames) throws InterruptedException {
        return this.get(this.pollFirstFromAnyAsync(timeout, unit, queueNames));
    }

    @Override
    public RFuture<V> pollFirstFromAnyAsync(long timeout, TimeUnit unit, String ... queueNames) {
        return this.pollFromAnyAsync(timeout, unit, queueNames);
    }

    @Override
    public V pollLastFromAny(long timeout, TimeUnit unit, String ... queueNames) throws InterruptedException {
        return this.get(this.pollLastFromAnyAsync(timeout, unit, queueNames));
    }

    @Override
    public RFuture<V> pollLastFromAnyAsync(long timeout, TimeUnit unit, String ... queueNames) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V pollFirst(long timeout, TimeUnit unit) throws InterruptedException {
        return this.get(this.pollFirstAsync(timeout, unit));
    }

    @Override
    public RFuture<V> pollLastAsync(long timeout, TimeUnit unit) {
        RedissonPromise result = new RedissonPromise();
        this.blockingQueue.takeAsync(result, 0L, unit.toMicros(timeout), RedisCommands.RPOP, this.getName());
        return result;
    }

    @Override
    public V pollLast(long timeout, TimeUnit unit) throws InterruptedException {
        return this.get(this.pollLastAsync(timeout, unit));
    }
}

