/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import java.util.ArrayList;
import java.util.List;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.redisson.RedissonKeys;
import org.redisson.client.RedisClient;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.reactive.CommandReactiveService;
import reactor.rx.Stream;
import reactor.rx.Streams;
import reactor.rx.subscription.ReactiveSubscription;

public class RedissonKeysReactive {
    private final CommandReactiveService commandExecutor;
    private final RedissonKeys instance;

    public RedissonKeysReactive(CommandReactiveService commandExecutor) {
        this.instance = new RedissonKeys(commandExecutor);
        this.commandExecutor = commandExecutor;
    }

    public Publisher<String> getKeysByPattern(String pattern) {
        return this.getKeysByPattern(pattern, 10);
    }

    public Publisher<String> getKeysByPattern(String pattern, int count) {
        ArrayList<Publisher<String>> publishers = new ArrayList<Publisher<String>>();
        for (MasterSlaveEntry entry : this.commandExecutor.getConnectionManager().getEntrySet()) {
            publishers.add(this.createKeysIterator(entry, pattern, count));
        }
        return Streams.merge(publishers);
    }

    private Publisher<String> createKeysIterator(final MasterSlaveEntry entry, final String pattern, final int count) {
        return new Stream<String>(){

            @Override
            public void subscribe(Subscriber<? super String> t) {
                t.onSubscribe(new ReactiveSubscription<String>((Stream)this, t){
                    private RedisClient client;
                    private List<String> firstValues;
                    private long nextIterPos;
                    private long currentIndex;

                    @Override
                    protected void onRequest(long n) {
                        this.currentIndex = n;
                        this.nextValues();
                    }

                    protected void nextValues() {
                        final 1 m = this;
                        RedissonKeysReactive.this.instance.scanIteratorAsync(this.client, entry, this.nextIterPos, pattern, count).addListener(new FutureListener<ListScanResult<Object>>(){

                            @Override
                            public void operationComplete(Future<ListScanResult<Object>> future) throws Exception {
                                if (!future.isSuccess()) {
                                    m.onError(future.cause());
                                    return;
                                }
                                ListScanResult res = (ListScanResult)future.get();
                                client = res.getRedisClient();
                                long prevIterPos = nextIterPos;
                                if (nextIterPos == 0L && firstValues == null) {
                                    firstValues = (List)res.getValues();
                                } else if (res.getValues().equals(firstValues)) {
                                    m.onComplete();
                                    currentIndex = 0L;
                                    return;
                                }
                                nextIterPos = res.getPos();
                                if (prevIterPos == nextIterPos) {
                                    nextIterPos = -1L;
                                }
                                for (Object val : res.getValues()) {
                                    m.onNext((String)val);
                                    currentIndex--;
                                    if (currentIndex != 0L) continue;
                                    m.onComplete();
                                    return;
                                }
                                if (nextIterPos == -1L) {
                                    m.onComplete();
                                    currentIndex = 0L;
                                }
                                if (currentIndex == 0L) {
                                    return;
                                }
                                this.nextValues();
                            }
                        });
                    }
                });
            }
        };
    }
}

