/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.redisson.api.RFuture;
import org.redisson.reactive.CommandReactiveExecutor;
import reactor.fn.Supplier;

public class ReactiveProxyBuilder {
    private static final ConcurrentMap<CacheKey, Method> methodsMapping = new ConcurrentHashMap<CacheKey, Method>();

    public static <T> T create(CommandReactiveExecutor commandExecutor, Object instance, Class<T> clazz) {
        return ReactiveProxyBuilder.create(commandExecutor, instance, null, clazz);
    }

    public static <T> T create(final CommandReactiveExecutor commandExecutor, final Object instance, final Object implementation, Class<T> clazz) {
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, final Object[] args) throws Throwable {
                CacheKey key = new CacheKey(method, instance.getClass());
                Method instanceMethod = (Method)methodsMapping.get(key);
                if (instanceMethod == null) {
                    if (implementation != null) {
                        try {
                            instanceMethod = implementation.getClass().getMethod(method.getName(), method.getParameterTypes());
                        }
                        catch (NoSuchMethodException e) {
                            try {
                                instanceMethod = instance.getClass().getMethod(method.getName() + "Async", method.getParameterTypes());
                            }
                            catch (Exception e2) {
                                instanceMethod = instance.getClass().getMethod(method.getName(), method.getParameterTypes());
                            }
                        }
                    } else {
                        try {
                            instanceMethod = instance.getClass().getMethod(method.getName() + "Async", method.getParameterTypes());
                        }
                        catch (NoSuchMethodException e) {
                            instanceMethod = instance.getClass().getMethod(method.getName(), method.getParameterTypes());
                        }
                    }
                    methodsMapping.put(key, instanceMethod);
                }
                final Method mm = instanceMethod;
                if (instanceMethod.getName().endsWith("Async")) {
                    return commandExecutor.reactive(new Supplier<RFuture<Object>>(){

                        @Override
                        public RFuture<Object> get() {
                            try {
                                return (RFuture)mm.invoke(instance, args);
                            }
                            catch (Exception e) {
                                throw new IllegalStateException(e);
                            }
                        }
                    });
                }
                if (implementation != null && instanceMethod.getDeclaringClass() == implementation.getClass()) {
                    return instanceMethod.invoke(implementation, args);
                }
                return instanceMethod.invoke(instance, args);
            }
        };
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, handler);
    }

    private static class CacheKey {
        Method method;
        Class<?> instanceClass;

        public CacheKey(Method method, Class<?> instanceClass) {
            this.method = method;
            this.instanceClass = instanceClass;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.instanceClass == null ? 0 : this.instanceClass.hashCode());
            result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.instanceClass == null ? other.instanceClass != null : !this.instanceClass.equals(other.instanceClass)) {
                return false;
            }
            return !(this.method == null ? other.method != null : !this.method.equals(other.method));
        }
    }
}

