/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import org.redisson.api.RFuture;
import reactor.rx.Promise;
import reactor.rx.Promises;
import reactor.rx.action.support.DefaultSubscriber;

public abstract class PublisherAdder<V> {
    public abstract RFuture<Boolean> add(Object var1);

    public Publisher<Boolean> addAll(Publisher<? extends V> c) {
        final Promise<Boolean> promise = Promises.prepare();
        c.subscribe(new DefaultSubscriber<V>(){
            volatile boolean completed;
            AtomicLong values = new AtomicLong();
            Subscription s;
            Boolean lastSize = false;

            @Override
            public void onSubscribe(Subscription s) {
                this.s = s;
                s.request(1L);
            }

            @Override
            public void onNext(V o) {
                this.values.getAndIncrement();
                PublisherAdder.this.add(o).addListener(new FutureListener<Boolean>(){

                    @Override
                    public void operationComplete(Future<Boolean> future) throws Exception {
                        if (!future.isSuccess()) {
                            promise.onError(future.cause());
                            return;
                        }
                        if (future.getNow().booleanValue()) {
                            lastSize = true;
                        }
                        s.request(1L);
                        if (values.decrementAndGet() == 0L && completed) {
                            promise.onNext(lastSize);
                        }
                    }
                });
            }

            @Override
            public void onComplete() {
                this.completed = true;
                if (this.values.get() == 0L) {
                    promise.onNext(this.lastSize);
                }
            }
        });
        return promise;
    }
}

