/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.pubsub;

import io.netty.util.internal.PlatformDependent;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.redisson.PubSubEntry;
import org.redisson.api.RFuture;
import org.redisson.client.BaseRedisPubSubListener;
import org.redisson.client.ChannelName;
import org.redisson.client.RedisPubSubListener;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.pubsub.PubSubType;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonPromise;
import org.redisson.misc.TransferListener;
import org.redisson.pubsub.AsyncSemaphore;
import org.redisson.pubsub.PublishSubscribeService;

abstract class PublishSubscribe<E extends PubSubEntry<E>> {
    private final ConcurrentMap<String, E> entries = PlatformDependent.newConcurrentHashMap();

    PublishSubscribe() {
    }

    public void unsubscribe(E entry, String entryName, String channelName, PublishSubscribeService subscribeService) {
        AsyncSemaphore semaphore = subscribeService.getSemaphore(new ChannelName(channelName));
        semaphore.acquire(new Runnable((PubSubEntry)entry, entryName, subscribeService, channelName, semaphore){
            final /* synthetic */ PubSubEntry val$entry;
            final /* synthetic */ String val$entryName;
            final /* synthetic */ PublishSubscribeService val$subscribeService;
            final /* synthetic */ String val$channelName;
            final /* synthetic */ AsyncSemaphore val$semaphore;
            {
                this.val$entry = pubSubEntry;
                this.val$entryName = string;
                this.val$subscribeService = publishSubscribeService;
                this.val$channelName = string2;
                this.val$semaphore = asyncSemaphore;
            }

            @Override
            public void run() {
                if (this.val$entry.release() == 0) {
                    boolean removed;
                    boolean bl = removed = PublishSubscribe.this.entries.remove(this.val$entryName) == this.val$entry;
                    if (!removed) {
                        throw new IllegalStateException();
                    }
                    this.val$subscribeService.unsubscribe(new ChannelName(this.val$channelName), this.val$semaphore);
                } else {
                    this.val$semaphore.release();
                }
            }
        });
    }

    public E getEntry(String entryName) {
        return (E)((PubSubEntry)this.entries.get(entryName));
    }

    public RFuture<E> subscribe(final String entryName, final String channelName, final PublishSubscribeService subscribeService) {
        final AtomicReference<3> listenerHolder = new AtomicReference<3>();
        final AsyncSemaphore semaphore = subscribeService.getSemaphore(new ChannelName(channelName));
        final RedissonPromise newPromise = new RedissonPromise<E>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return semaphore.remove((Runnable)listenerHolder.get());
            }
        };
        Runnable listener = new Runnable(){

            @Override
            public void run() {
                PubSubEntry entry = (PubSubEntry)PublishSubscribe.this.entries.get(entryName);
                if (entry != null) {
                    entry.aquire();
                    semaphore.release();
                    entry.getPromise().addListener(new TransferListener(newPromise));
                    return;
                }
                Object value = PublishSubscribe.this.createEntry(newPromise);
                value.aquire();
                PubSubEntry oldValue = (PubSubEntry)PublishSubscribe.this.entries.putIfAbsent(entryName, value);
                if (oldValue != null) {
                    oldValue.aquire();
                    semaphore.release();
                    oldValue.getPromise().addListener(new TransferListener(newPromise));
                    return;
                }
                RedisPubSubListener listener = PublishSubscribe.this.createListener(channelName, value);
                subscribeService.subscribe((Codec)LongCodec.INSTANCE, channelName, semaphore, listener);
            }
        };
        semaphore.acquire(listener);
        listenerHolder.set(listener);
        return newPromise;
    }

    protected abstract E createEntry(RPromise<E> var1);

    protected abstract void onMessage(E var1, Long var2);

    private RedisPubSubListener<Object> createListener(final String channelName, E value) {
        BaseRedisPubSubListener listener = new BaseRedisPubSubListener((PubSubEntry)value){
            final /* synthetic */ PubSubEntry val$value;
            {
                this.val$value = pubSubEntry;
            }

            @Override
            public void onMessage(CharSequence channel, Object message) {
                if (!channelName.equals(channel.toString())) {
                    return;
                }
                PublishSubscribe.this.onMessage(this.val$value, (Long)message);
            }

            @Override
            public boolean onStatus(PubSubType type, CharSequence channel) {
                if (!channelName.equals(channel.toString())) {
                    return false;
                }
                if (type == PubSubType.SUBSCRIBE) {
                    this.val$value.getPromise().trySuccess(this.val$value);
                    return true;
                }
                return false;
            }
        };
        return listener;
    }
}

