/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.config;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.UUID;
import org.redisson.api.RedissonNodeInitializer;
import org.redisson.client.codec.Codec;
import org.redisson.cluster.ClusterConnectionManager;
import org.redisson.codec.ReferenceCodecProvider;
import org.redisson.config.BaseMasterSlaveServersConfig;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.ElasticacheServersConfig;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.ReplicatedServersConfig;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.redisson.connection.AddressResolverGroupFactory;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.ElasticacheConnectionManager;
import org.redisson.connection.MasterSlaveConnectionManager;
import org.redisson.connection.ReplicatedConnectionManager;
import org.redisson.connection.SentinelConnectionManager;
import org.redisson.connection.SingleConnectionManager;
import org.redisson.connection.balancer.LoadBalancer;

public class ConfigSupport {
    private ObjectMapper jsonMapper = this.createMapper(null, null);
    private ObjectMapper yamlMapper = this.createMapper(new YAMLFactory(), null);

    public <T> T fromJSON(String content, Class<T> configType) throws IOException {
        return this.jsonMapper.readValue(content, configType);
    }

    public <T> T fromJSON(File file, Class<T> configType) throws IOException {
        return this.fromJSON(file, configType, null);
    }

    public <T> T fromJSON(File file, Class<T> configType, ClassLoader classLoader) throws IOException {
        this.jsonMapper = this.createMapper(null, classLoader);
        return this.jsonMapper.readValue(file, configType);
    }

    public <T> T fromJSON(URL url, Class<T> configType) throws IOException {
        return this.jsonMapper.readValue(url, configType);
    }

    public <T> T fromJSON(Reader reader, Class<T> configType) throws IOException {
        return this.jsonMapper.readValue(reader, configType);
    }

    public <T> T fromJSON(InputStream inputStream, Class<T> configType) throws IOException {
        return this.jsonMapper.readValue(inputStream, configType);
    }

    public String toJSON(Config config) throws IOException {
        return this.jsonMapper.writeValueAsString(config);
    }

    public <T> T fromYAML(String content, Class<T> configType) throws IOException {
        return this.yamlMapper.readValue(content, configType);
    }

    public <T> T fromYAML(File file, Class<T> configType) throws IOException {
        return this.yamlMapper.readValue(file, configType);
    }

    public <T> T fromYAML(File file, Class<T> configType, ClassLoader classLoader) throws IOException {
        this.yamlMapper = this.createMapper(new YAMLFactory(), classLoader);
        return this.yamlMapper.readValue(file, configType);
    }

    public <T> T fromYAML(URL url, Class<T> configType) throws IOException {
        return this.yamlMapper.readValue(url, configType);
    }

    public <T> T fromYAML(Reader reader, Class<T> configType) throws IOException {
        return this.yamlMapper.readValue(reader, configType);
    }

    public <T> T fromYAML(InputStream inputStream, Class<T> configType) throws IOException {
        return this.yamlMapper.readValue(inputStream, configType);
    }

    public String toYAML(Config config) throws IOException {
        return this.yamlMapper.writeValueAsString(config);
    }

    public static ConnectionManager createConnectionManager(Config configCopy) {
        UUID id = UUID.randomUUID();
        if (configCopy.getMasterSlaveServersConfig() != null) {
            ConfigSupport.validate(configCopy.getMasterSlaveServersConfig());
            return new MasterSlaveConnectionManager(configCopy.getMasterSlaveServersConfig(), configCopy, id);
        }
        if (configCopy.getSingleServerConfig() != null) {
            ConfigSupport.validate(configCopy.getSingleServerConfig());
            return new SingleConnectionManager(configCopy.getSingleServerConfig(), configCopy, id);
        }
        if (configCopy.getSentinelServersConfig() != null) {
            ConfigSupport.validate(configCopy.getSentinelServersConfig());
            return new SentinelConnectionManager(configCopy.getSentinelServersConfig(), configCopy, id);
        }
        if (configCopy.getClusterServersConfig() != null) {
            ConfigSupport.validate(configCopy.getClusterServersConfig());
            return new ClusterConnectionManager(configCopy.getClusterServersConfig(), configCopy, id);
        }
        if (configCopy.getElasticacheServersConfig() != null) {
            ConfigSupport.validate(configCopy.getElasticacheServersConfig());
            return new ElasticacheConnectionManager(configCopy.getElasticacheServersConfig(), configCopy, id);
        }
        if (configCopy.getReplicatedServersConfig() != null) {
            ConfigSupport.validate(configCopy.getReplicatedServersConfig());
            return new ReplicatedConnectionManager(configCopy.getReplicatedServersConfig(), configCopy, id);
        }
        if (configCopy.getConnectionManager() != null) {
            return configCopy.getConnectionManager();
        }
        throw new IllegalArgumentException("server(s) address(es) not defined!");
    }

    private static void validate(SingleServerConfig config) {
        if (config.getConnectionPoolSize() < config.getConnectionMinimumIdleSize()) {
            throw new IllegalArgumentException("connectionPoolSize can't be lower than connectionMinimumIdleSize");
        }
    }

    private static void validate(BaseMasterSlaveServersConfig<?> config) {
        if (config.getSlaveConnectionPoolSize() < config.getSlaveConnectionMinimumIdleSize()) {
            throw new IllegalArgumentException("slaveConnectionPoolSize can't be lower than slaveConnectionMinimumIdleSize");
        }
        if (config.getMasterConnectionPoolSize() < config.getMasterConnectionMinimumIdleSize()) {
            throw new IllegalArgumentException("masterConnectionPoolSize can't be lower than masterConnectionMinimumIdleSize");
        }
        if (config.getSubscriptionConnectionPoolSize() < config.getSubscriptionConnectionMinimumIdleSize()) {
            throw new IllegalArgumentException("slaveSubscriptionConnectionMinimumIdleSize can't be lower than slaveSubscriptionConnectionPoolSize");
        }
    }

    private ObjectMapper createMapper(JsonFactory mapping, ClassLoader classLoader) {
        ObjectMapper mapper = new ObjectMapper(mapping);
        mapper.addMixIn(MasterSlaveServersConfig.class, MasterSlaveServersConfigMixIn.class);
        mapper.addMixIn(SingleServerConfig.class, SingleSeverConfigMixIn.class);
        mapper.addMixIn(Config.class, ConfigMixIn.class);
        mapper.addMixIn(ReferenceCodecProvider.class, ClassMixIn.class);
        mapper.addMixIn(AddressResolverGroupFactory.class, ClassMixIn.class);
        mapper.addMixIn(Codec.class, ClassMixIn.class);
        mapper.addMixIn(RedissonNodeInitializer.class, ClassMixIn.class);
        mapper.addMixIn(LoadBalancer.class, ClassMixIn.class);
        SimpleFilterProvider filterProvider = new SimpleFilterProvider().addFilter("classFilter", SimpleBeanPropertyFilter.filterOutAllExcept(new String[0]));
        mapper.setFilterProvider(filterProvider);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        if (classLoader != null) {
            TypeFactory tf = TypeFactory.defaultInstance().withClassLoader(classLoader);
            mapper.setTypeFactory(tf);
        }
        return mapper;
    }

    @JsonIgnoreProperties(value={"clusterConfig", "sentinelConfig"})
    public static class ConfigMixIn {
        @JsonProperty
        SentinelServersConfig sentinelServersConfig;
        @JsonProperty
        MasterSlaveServersConfig masterSlaveServersConfig;
        @JsonProperty
        SingleServerConfig singleServerConfig;
        @JsonProperty
        ClusterServersConfig clusterServersConfig;
        @JsonProperty
        ElasticacheServersConfig elasticacheServersConfig;
        @JsonProperty
        ReplicatedServersConfig replicatedServersConfig;
    }

    public static abstract class MasterSlaveServersConfigMixIn {
        @JsonProperty
        List<URI> masterAddress;

        @JsonIgnore
        abstract MasterSlaveServersConfig setMasterAddress(String var1);

        @JsonIgnore
        abstract URI getMasterAddress();

        @JsonIgnore
        abstract void setMasterAddress(URI var1);
    }

    public static abstract class SingleSeverConfigMixIn {
        @JsonProperty
        List<URI> address;

        @JsonIgnore
        abstract SingleServerConfig setAddress(String var1);

        @JsonIgnore
        abstract URI getAddress();

        @JsonIgnore
        abstract void setAddress(URI var1);
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="class")
    @JsonFilter(value="classFilter")
    public static class ClassMixIn {
    }
}

