/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.protocol.decoder;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.redisson.client.codec.Codec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.decoder.MultiDecoder;

public class ObjectMapDecoder
implements MultiDecoder<Map<Object, Object>> {
    private Codec codec;
    private int pos;

    public ObjectMapDecoder(Codec codec) {
        this.codec = codec;
    }

    @Override
    public Decoder<Object> getDecoder(int paramNum, State state) {
        if (this.pos++ % 2 == 0) {
            return this.codec.getMapKeyDecoder();
        }
        return this.codec.getMapValueDecoder();
    }

    @Override
    public Map<Object, Object> decode(List<Object> parts, State state) {
        LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>(parts.size() / 2);
        for (int i = 0; i < parts.size(); ++i) {
            if (i % 2 == 0) continue;
            result.put(parts.get(i - 1), parts.get(i));
        }
        return result;
    }
}

