/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.redisson.RedissonExpirable;
import org.redisson.api.RFuture;
import org.redisson.api.RSemaphore;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.redisson.api.listener.MessageListener;
import org.redisson.client.codec.LongCodec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonPromise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RedissonBaseAdder<T extends Number>
extends RedissonExpirable {
    private static final Logger log = LoggerFactory.getLogger(RedissonBaseAdder.class);
    private static final long CLEAR_MSG = 0L;
    private static final long SUM_MSG = 1L;
    private final RSemaphore semaphore;
    private final RTopic<Long> topic;
    private final int listenerId;

    public RedissonBaseAdder(CommandAsyncExecutor connectionManager, String name, RedissonClient redisson) {
        super(connectionManager, name);
        this.topic = redisson.getTopic(RedissonBaseAdder.suffixName(this.getName(), "topic"), LongCodec.INSTANCE);
        this.semaphore = redisson.getSemaphore(RedissonBaseAdder.suffixName(this.getName(), "semaphore"));
        this.listenerId = this.topic.addListener(new MessageListener<Long>(){

            @Override
            public void onMessage(CharSequence channel, Long msg) {
                if (msg == 1L) {
                    RFuture addAndGetFuture = RedissonBaseAdder.this.addAndGetAsync();
                    addAndGetFuture.addListener(new FutureListener<T>(){

                        @Override
                        public void operationComplete(Future<T> future) throws Exception {
                            if (!future.isSuccess()) {
                                log.error("Can't increase sum", future.cause());
                                return;
                            }
                            RedissonBaseAdder.this.semaphore.releaseAsync().addListener(new FutureListener<Void>(){

                                @Override
                                public void operationComplete(Future<Void> future) throws Exception {
                                    if (!future.isSuccess()) {
                                        log.error("Can't release semaphore", future.cause());
                                        return;
                                    }
                                }
                            });
                        }
                    });
                }
                if (msg == 0L) {
                    RedissonBaseAdder.this.doReset();
                    RedissonBaseAdder.this.semaphore.releaseAsync().addListener(new FutureListener<Void>(){

                        @Override
                        public void operationComplete(Future<Void> future) throws Exception {
                            if (!future.isSuccess()) {
                                log.error("Can't release semaphore", future.cause());
                                return;
                            }
                        }
                    });
                }
            }
        });
    }

    protected abstract void doReset();

    public void reset() {
        this.get(this.resetAsync());
    }

    public void reset(long timeout, TimeUnit timeUnit) {
        this.get(this.resetAsync(timeout, timeUnit));
    }

    public RFuture<T> sumAsync() {
        RedissonPromise result = new RedissonPromise();
        RFuture<Long> future = this.topic.publishAsync(1L);
        future.addListener(new SumListener(result));
        return result;
    }

    public RFuture<T> sumAsync(final long timeout, final TimeUnit timeUnit) {
        RedissonPromise result = new RedissonPromise();
        RFuture<Long> future = this.topic.publishAsync(1L);
        future.addListener(new SumListener(result){

            @Override
            protected RFuture<Void> acquireAsync(int value) {
                return RedissonBaseAdder.this.tryAcquire(timeout, timeUnit, value);
            }
        });
        return result;
    }

    protected RFuture<Void> tryAcquire(long timeout, TimeUnit timeUnit, int value) {
        final RedissonPromise<Void> acquireResult = new RedissonPromise<Void>();
        this.semaphore.tryAcquireAsync(value, timeout, timeUnit).addListener(new FutureListener<Boolean>(){

            @Override
            public void operationComplete(Future<Boolean> future) throws Exception {
                if (!future.isSuccess()) {
                    acquireResult.tryFailure(future.cause());
                    return;
                }
                if (future.getNow().booleanValue()) {
                    acquireResult.trySuccess(null);
                } else {
                    acquireResult.tryFailure(new TimeoutException());
                }
            }
        });
        return acquireResult;
    }

    public RFuture<Void> resetAsync() {
        RedissonPromise<Void> result = new RedissonPromise<Void>();
        RFuture<Long> future = this.topic.publishAsync(0L);
        future.addListener(new ResetListener(result));
        return result;
    }

    public RFuture<Void> resetAsync(final long timeout, final TimeUnit timeUnit) {
        RedissonPromise<Void> result = new RedissonPromise<Void>();
        RFuture<Long> future = this.topic.publishAsync(0L);
        future.addListener(new ResetListener(result){

            @Override
            protected RFuture<Void> acquireAsync(int value) {
                return RedissonBaseAdder.this.tryAcquire(timeout, timeUnit, value);
            }
        });
        return result;
    }

    public void destroy() {
        this.topic.removeListener(this.listenerId);
    }

    protected abstract RFuture<T> addAndGetAsync();

    protected abstract RFuture<T> getAndDeleteAsync();

    private class SumListener
    implements FutureListener<Long> {
        private final RPromise<T> result;

        private SumListener(RPromise<T> result) {
            this.result = result;
        }

        @Override
        public void operationComplete(Future<Long> future) throws Exception {
            if (!future.isSuccess()) {
                this.result.tryFailure(future.cause());
                return;
            }
            this.acquireAsync(future.getNow().intValue()).addListener(new FutureListener<Void>(){

                @Override
                public void operationComplete(Future<Void> future) throws Exception {
                    if (!future.isSuccess()) {
                        SumListener.this.result.tryFailure(future.cause());
                        return;
                    }
                    RFuture valueFuture = RedissonBaseAdder.this.getAndDeleteAsync();
                    valueFuture.addListener(new FutureListener<T>(){

                        @Override
                        public void operationComplete(Future<T> future) throws Exception {
                            if (!future.isSuccess()) {
                                SumListener.this.result.tryFailure(future.cause());
                                return;
                            }
                            SumListener.this.result.trySuccess(future.getNow());
                        }
                    });
                }
            });
        }

        protected RFuture<Void> acquireAsync(int value) {
            return RedissonBaseAdder.this.semaphore.acquireAsync(value);
        }
    }

    private class ResetListener
    implements FutureListener<Long> {
        private final RPromise<Void> result;

        private ResetListener(RPromise<Void> result) {
            this.result = result;
        }

        @Override
        public void operationComplete(Future<Long> future) throws Exception {
            if (!future.isSuccess()) {
                this.result.tryFailure(future.cause());
                return;
            }
            this.acquireAsync(future.getNow().intValue()).addListener(new FutureListener<Void>(){

                @Override
                public void operationComplete(Future<Void> future) throws Exception {
                    if (!future.isSuccess()) {
                        ResetListener.this.result.tryFailure(future.cause());
                        return;
                    }
                    ResetListener.this.result.trySuccess(null);
                }
            });
        }

        protected RFuture<Void> acquireAsync(int value) {
            return RedissonBaseAdder.this.semaphore.acquireAsync(value);
        }
    }
}

