/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.BitSet;
import org.reactivestreams.Publisher;
import org.redisson.RedissonBitSet;
import org.redisson.api.RBitSetAsync;
import org.redisson.api.RBitSetReactive;
import org.redisson.api.RFuture;
import org.redisson.client.codec.BitSetCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandReactiveExecutor;
import org.redisson.reactive.RedissonExpirableReactive;
import reactor.fn.Supplier;
import reactor.rx.Streams;

public class RedissonBitSetReactive
extends RedissonExpirableReactive
implements RBitSetReactive {
    private final RBitSetAsync instance;

    public RedissonBitSetReactive(CommandReactiveExecutor connectionManager, String name) {
        this(connectionManager, name, new RedissonBitSet(connectionManager, name));
    }

    public RedissonBitSetReactive(CommandReactiveExecutor connectionManager, String name, RBitSetAsync instance) {
        super(connectionManager, name, instance);
        this.instance = instance;
    }

    @Override
    public Publisher<Boolean> get(final long bitIndex) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonBitSetReactive.this.instance.getAsync(bitIndex);
            }
        });
    }

    @Override
    public Publisher<Boolean> set(final long bitIndex, final boolean value) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonBitSetReactive.this.instance.setAsync(bitIndex, value);
            }
        });
    }

    @Override
    public Publisher<byte[]> toByteArray() {
        return this.reactive(new Supplier<RFuture<byte[]>>(){

            @Override
            public RFuture<byte[]> get() {
                return RedissonBitSetReactive.this.instance.toByteArrayAsync();
            }
        });
    }

    @Override
    public Publisher<BitSet> asBitSet() {
        return this.commandExecutor.readReactive(this.getName(), BitSetCodec.INSTANCE, RedisCommands.GET, this.getName());
    }

    @Override
    public Publisher<Long> length() {
        return this.reactive(new Supplier<RFuture<Long>>(){

            @Override
            public RFuture<Long> get() {
                return RedissonBitSetReactive.this.instance.lengthAsync();
            }
        });
    }

    @Override
    public Publisher<Void> set(final long fromIndex, final long toIndex, final boolean value) {
        return this.reactive(new Supplier<RFuture<Void>>(){

            @Override
            public RFuture<Void> get() {
                return RedissonBitSetReactive.this.instance.setAsync(fromIndex, toIndex, value);
            }
        });
    }

    @Override
    public Publisher<Void> clear(final long fromIndex, final long toIndex) {
        return this.reactive(new Supplier<RFuture<Void>>(){

            @Override
            public RFuture<Void> get() {
                return RedissonBitSetReactive.this.instance.clearAsync(fromIndex, toIndex);
            }
        });
    }

    @Override
    public Publisher<Void> set(final BitSet bs) {
        return this.reactive(new Supplier<RFuture<Void>>(){

            @Override
            public RFuture<Void> get() {
                return RedissonBitSetReactive.this.instance.setAsync(bs);
            }
        });
    }

    @Override
    public Publisher<Void> not() {
        return this.reactive(new Supplier<RFuture<Void>>(){

            @Override
            public RFuture<Void> get() {
                return RedissonBitSetReactive.this.instance.notAsync();
            }
        });
    }

    @Override
    public Publisher<Void> set(final long fromIndex, final long toIndex) {
        return this.reactive(new Supplier<RFuture<Void>>(){

            @Override
            public RFuture<Void> get() {
                return RedissonBitSetReactive.this.instance.setAsync(fromIndex, toIndex);
            }
        });
    }

    @Override
    public Publisher<Long> size() {
        return this.reactive(new Supplier<RFuture<Long>>(){

            @Override
            public RFuture<Long> get() {
                return RedissonBitSetReactive.this.instance.sizeAsync();
            }
        });
    }

    @Override
    public Publisher<Boolean> set(final long bitIndex) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonBitSetReactive.this.instance.setAsync(bitIndex);
            }
        });
    }

    @Override
    public Publisher<Long> cardinality() {
        return this.reactive(new Supplier<RFuture<Long>>(){

            @Override
            public RFuture<Long> get() {
                return RedissonBitSetReactive.this.instance.cardinalityAsync();
            }
        });
    }

    @Override
    public Publisher<Boolean> clear(final long bitIndex) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonBitSetReactive.this.instance.clearAsync(bitIndex);
            }
        });
    }

    @Override
    public Publisher<Void> clear() {
        return this.reactive(new Supplier<RFuture<Void>>(){

            @Override
            public RFuture<Void> get() {
                return RedissonBitSetReactive.this.instance.clearAsync();
            }
        });
    }

    @Override
    public Publisher<Void> or(final String ... bitSetNames) {
        return this.reactive(new Supplier<RFuture<Void>>(){

            @Override
            public RFuture<Void> get() {
                return RedissonBitSetReactive.this.instance.orAsync(bitSetNames);
            }
        });
    }

    @Override
    public Publisher<Void> and(final String ... bitSetNames) {
        return this.reactive(new Supplier<RFuture<Void>>(){

            @Override
            public RFuture<Void> get() {
                return RedissonBitSetReactive.this.instance.andAsync(bitSetNames);
            }
        });
    }

    @Override
    public Publisher<Void> xor(final String ... bitSetNames) {
        return this.reactive(new Supplier<RFuture<Void>>(){

            @Override
            public RFuture<Void> get() {
                return RedissonBitSetReactive.this.instance.xorAsync(bitSetNames);
            }
        });
    }

    public String toString() {
        return Streams.create(this.asBitSet()).next().poll().toString();
    }
}

