/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.misc;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.URI;

public class URIBuilder {
    public static URI create(String uri) {
        URI u = URI.create(uri);
        if (u.getHost() != null) {
            return u;
        }
        String s = uri.substring(0, uri.lastIndexOf(":")).replaceFirst("redis://", "").replaceFirst("rediss://", "");
        return URI.create(uri.replace(s, "[" + s + "]"));
    }

    public static void patchUriObject() {
        try {
            URIBuilder.patchUriField(0x200000000000L, "L_DASH");
            URIBuilder.patchUriField(0x80000000L, "H_DASH");
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void patchUriField(Long maskValue, String fieldName) throws IOException {
        try {
            Field field = URI.class.getDeclaredField(fieldName);
            Field modifiers = Field.class.getDeclaredField("modifiers");
            modifiers.setAccessible(true);
            modifiers.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            field.setAccessible(true);
            field.setLong(null, maskValue);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static boolean compare(InetSocketAddress entryAddr, URI addr) {
        return (entryAddr.getHostName() != null && entryAddr.getHostName().equals(addr.getHost()) || entryAddr.getAddress().getHostAddress().equals(addr.getHost())) && entryAddr.getPort() == addr.getPort();
    }
}

