/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.redisson.client.codec.BaseCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;
import org.redisson.codec.FstCodec;
import org.xerial.snappy.SnappyInputStream;
import org.xerial.snappy.SnappyOutputStream;

public class SnappyCodecV2
extends BaseCodec {
    private final Codec innerCodec;
    private final Decoder<Object> decoder = new Decoder<Object>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object decode(ByteBuf buf, State state) throws IOException {
            SnappyInputStream input = new SnappyInputStream((InputStream)new ByteBufInputStream(buf));
            ByteBuf bf = ByteBufAllocator.DEFAULT.buffer(buf.readableBytes());
            bf.writeBytes((InputStream)input, buf.readableBytes());
            try {
                Object object = SnappyCodecV2.this.innerCodec.getValueDecoder().decode(bf, state);
                return object;
            }
            finally {
                bf.release();
            }
        }
    };
    private final Encoder encoder = new Encoder(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ByteBuf encode(Object in) throws IOException {
            ByteBuf encoded = SnappyCodecV2.this.innerCodec.getValueEncoder().encode(in);
            ByteBuf out = ByteBufAllocator.DEFAULT.buffer(encoded.readableBytes());
            try {
                SnappyOutputStream output = new SnappyOutputStream((OutputStream)new ByteBufOutputStream(out));
                encoded.readBytes((OutputStream)output, encoded.readableBytes());
                output.flush();
            }
            finally {
                encoded.release();
            }
            return out;
        }
    };

    public SnappyCodecV2() {
        this(new FstCodec());
    }

    public SnappyCodecV2(Codec innerCodec) {
        this.innerCodec = innerCodec;
    }

    public SnappyCodecV2(ClassLoader classLoader) {
        this(new FstCodec(classLoader));
    }

    @Override
    public Decoder<Object> getValueDecoder() {
        return this.decoder;
    }

    @Override
    public Encoder getValueEncoder() {
        return this.encoder;
    }
}

