/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.Collections;
import java.util.List;
import org.redisson.PubSubPatternMessageListener;
import org.redisson.PubSubPatternStatusListener;
import org.redisson.api.RFuture;
import org.redisson.api.RPatternTopic;
import org.redisson.api.listener.PatternMessageListener;
import org.redisson.api.listener.PatternStatusListener;
import org.redisson.client.ChannelName;
import org.redisson.client.RedisPubSubListener;
import org.redisson.client.RedisTimeoutException;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandExecutor;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.pubsub.AsyncSemaphore;
import org.redisson.pubsub.PubSubConnectionEntry;
import org.redisson.pubsub.PublishSubscribeService;

public class RedissonPatternTopic<M>
implements RPatternTopic<M> {
    final PublishSubscribeService subscribeService;
    final CommandExecutor commandExecutor;
    private final String name;
    private final ChannelName channelName;
    private final Codec codec;

    protected RedissonPatternTopic(CommandExecutor commandExecutor, String name) {
        this(commandExecutor.getConnectionManager().getCodec(), commandExecutor, name);
    }

    protected RedissonPatternTopic(Codec codec, CommandExecutor commandExecutor, String name) {
        this.commandExecutor = commandExecutor;
        this.name = name;
        this.channelName = new ChannelName(name);
        this.codec = codec;
        this.subscribeService = commandExecutor.getConnectionManager().getSubscribeService();
    }

    @Override
    public int addListener(PatternStatusListener listener) {
        return this.addListener(new PubSubPatternStatusListener(listener, this.name));
    }

    @Override
    public int addListener(PatternMessageListener<M> listener) {
        PubSubPatternMessageListener<M> pubSubListener = new PubSubPatternMessageListener<M>(listener, this.name);
        return this.addListener(pubSubListener);
    }

    @Override
    private int addListener(RedisPubSubListener<?> pubSubListener) {
        RFuture<PubSubConnectionEntry> future = this.subscribeService.psubscribe(this.channelName, this.codec, pubSubListener);
        this.commandExecutor.syncSubscription(future);
        return System.identityHashCode(pubSubListener);
    }

    protected void acquire(AsyncSemaphore semaphore) {
        MasterSlaveServersConfig config = this.commandExecutor.getConnectionManager().getConfig();
        int timeout = config.getTimeout() + config.getRetryInterval() * config.getRetryAttempts();
        if (!semaphore.tryAcquire(timeout)) {
            throw new RedisTimeoutException("Remove listeners operation timeout: (" + timeout + "ms) for " + this.name + " topic");
        }
    }

    @Override
    public void removeListener(int listenerId) {
        AsyncSemaphore semaphore = this.subscribeService.getSemaphore(this.channelName);
        this.acquire(semaphore);
        PubSubConnectionEntry entry = this.subscribeService.getPubSubEntry(this.channelName);
        if (entry == null) {
            semaphore.release();
            return;
        }
        entry.removeListener(this.channelName, listenerId);
        if (!entry.hasListeners(this.channelName)) {
            this.subscribeService.punsubscribe(this.channelName, semaphore);
        } else {
            semaphore.release();
        }
    }

    @Override
    public void removeAllListeners() {
        AsyncSemaphore semaphore = this.subscribeService.getSemaphore(this.channelName);
        this.acquire(semaphore);
        PubSubConnectionEntry entry = this.subscribeService.getPubSubEntry(this.channelName);
        if (entry == null) {
            semaphore.release();
            return;
        }
        entry.removeAllListeners(this.channelName);
        if (!entry.hasListeners(this.channelName)) {
            this.subscribeService.punsubscribe(this.channelName, semaphore);
        } else {
            semaphore.release();
        }
    }

    @Override
    public void removeListener(PatternMessageListener<M> listener) {
        AsyncSemaphore semaphore = this.subscribeService.getSemaphore(this.channelName);
        this.acquire(semaphore);
        PubSubConnectionEntry entry = this.subscribeService.getPubSubEntry(this.channelName);
        if (entry == null) {
            semaphore.release();
            return;
        }
        entry.removeListener(this.channelName, listener);
        if (!entry.hasListeners(this.channelName)) {
            this.subscribeService.punsubscribe(this.channelName, semaphore);
        } else {
            semaphore.release();
        }
    }

    @Override
    public List<String> getPatternNames() {
        return Collections.singletonList(this.name);
    }
}

