/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import org.redisson.RedissonBaseAdder;
import org.redisson.api.RAtomicDouble;
import org.redisson.api.RDoubleAdder;
import org.redisson.api.RFuture;
import org.redisson.api.RedissonClient;
import org.redisson.command.CommandAsyncExecutor;

public class RedissonDoubleAdder
extends RedissonBaseAdder<Double>
implements RDoubleAdder {
    private double counter;
    private final RAtomicDouble atomicDouble;

    public RedissonDoubleAdder(CommandAsyncExecutor connectionManager, String name, RedissonClient redisson) {
        super(connectionManager, name, redisson);
        this.atomicDouble = redisson.getAtomicDouble(this.getName());
    }

    @Override
    protected synchronized void doReset() {
        this.counter = 0.0;
    }

    @Override
    protected synchronized RFuture<Double> addAndGetAsync() {
        return this.atomicDouble.getAndAddAsync(this.counter);
    }

    @Override
    protected RFuture<Double> getAndDeleteAsync() {
        return this.atomicDouble.getAndDeleteAsync();
    }

    @Override
    public synchronized void add(double x) {
        this.counter += x;
    }

    @Override
    public void increment() {
        this.add(1.0);
    }

    @Override
    public void decrement() {
        this.add(-1.0);
    }

    @Override
    public double sum() {
        return (Double)this.get(this.sumAsync());
    }
}

