/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import org.reactivestreams.Publisher;
import org.redisson.RedissonQueue;
import org.redisson.api.RFuture;
import org.redisson.api.RQueueAsync;
import org.redisson.api.RQueueReactive;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandReactiveExecutor;
import org.redisson.reactive.RedissonListReactive;
import reactor.fn.Supplier;

public class RedissonQueueReactive<V>
extends RedissonListReactive<V>
implements RQueueReactive<V> {
    private final RQueueAsync<V> instance;

    public RedissonQueueReactive(CommandReactiveExecutor commandExecutor, String name) {
        super(commandExecutor, name);
        this.instance = new RedissonQueue(commandExecutor, name, null);
    }

    public RedissonQueueReactive(Codec codec, CommandReactiveExecutor commandExecutor, String name) {
        super(codec, commandExecutor, name);
        this.instance = new RedissonQueue(codec, commandExecutor, name, null);
    }

    @Override
    public Publisher<Integer> offer(V e) {
        return this.add(e);
    }

    @Override
    public Publisher<V> poll() {
        return this.reactive(new Supplier<RFuture<V>>(){

            @Override
            public RFuture<V> get() {
                return RedissonQueueReactive.this.instance.pollAsync();
            }
        });
    }

    @Override
    public Publisher<V> peek() {
        return this.get(0L);
    }

    @Override
    public Publisher<V> pollLastAndOfferFirstTo(final String queueName) {
        return this.reactive(new Supplier<RFuture<V>>(){

            @Override
            public RFuture<V> get() {
                return RedissonQueueReactive.this.instance.pollLastAndOfferFirstToAsync(queueName);
            }
        });
    }
}

