/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;
import org.redisson.RedissonMapCache;
import org.redisson.api.MapOptions;
import org.redisson.api.RFuture;
import org.redisson.api.RMapCacheAsync;
import org.redisson.api.RMapCacheReactive;
import org.redisson.api.RMapReactive;
import org.redisson.client.RedisClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.decoder.MapScanResult;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandReactiveExecutor;
import org.redisson.eviction.EvictionScheduler;
import org.redisson.reactive.MapReactive;
import org.redisson.reactive.RedissonExpirableReactive;
import org.redisson.reactive.RedissonMapReactiveIterator;
import reactor.fn.BiFunction;
import reactor.fn.Function;
import reactor.fn.Supplier;
import reactor.rx.Streams;

public class RedissonMapCacheReactive<K, V>
extends RedissonExpirableReactive
implements RMapCacheReactive<K, V>,
MapReactive<K, V> {
    private final RMapCacheAsync<K, V> mapCache;

    public RedissonMapCacheReactive(EvictionScheduler evictionScheduler, CommandReactiveExecutor commandExecutor, String name, MapOptions<K, V> options) {
        this(commandExecutor, name, options, new RedissonMapCache<K, V>(evictionScheduler, (CommandAsyncExecutor)commandExecutor, name, null, options));
    }

    public RedissonMapCacheReactive(CommandReactiveExecutor commandExecutor, String name, MapOptions<K, V> options, RMapCacheAsync<K, V> mapCache) {
        super(commandExecutor, name, mapCache);
        this.mapCache = mapCache;
    }

    public RedissonMapCacheReactive(EvictionScheduler evictionScheduler, Codec codec, CommandReactiveExecutor commandExecutor, String name, MapOptions<K, V> options) {
        this(codec, commandExecutor, name, options, new RedissonMapCache<K, V>(codec, evictionScheduler, commandExecutor, name, null, options));
    }

    public RedissonMapCacheReactive(Codec codec, CommandReactiveExecutor commandExecutor, String name, MapOptions<K, V> options, RMapCacheAsync<K, V> mapCache) {
        super(codec, commandExecutor, name, mapCache);
        this.mapCache = mapCache;
    }

    @Override
    public Publisher<Void> setMaxSize(final int maxSize) {
        return this.reactive(new Supplier<RFuture<Void>>(){

            @Override
            public RFuture<Void> get() {
                return RedissonMapCacheReactive.this.mapCache.setMaxSizeAsync(maxSize);
            }
        });
    }

    @Override
    public Publisher<Boolean> trySetMaxSize(final int maxSize) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonMapCacheReactive.this.mapCache.trySetMaxSizeAsync(maxSize);
            }
        });
    }

    @Override
    public Publisher<Long> remainTimeToLive(final K key) {
        return this.reactive(new Supplier<RFuture<Long>>(){

            @Override
            public RFuture<Long> get() {
                return RedissonMapCacheReactive.this.mapCache.remainTimeToLiveAsync(key);
            }
        });
    }

    @Override
    public Publisher<Boolean> containsKey(final Object key) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonMapCacheReactive.this.mapCache.containsKeyAsync(key);
            }
        });
    }

    @Override
    public Publisher<Boolean> containsValue(final Object value) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonMapCacheReactive.this.mapCache.containsValueAsync(value);
            }
        });
    }

    @Override
    public Publisher<Map<K, V>> getAll(final Set<K> keys) {
        return this.reactive(new Supplier<RFuture<Map<K, V>>>(){

            @Override
            public RFuture<Map<K, V>> get() {
                return RedissonMapCacheReactive.this.mapCache.getAllAsync(keys);
            }
        });
    }

    @Override
    public Publisher<V> putIfAbsent(final K key, final V value, final long ttl, final TimeUnit unit) {
        return this.reactive(new Supplier<RFuture<V>>(){

            @Override
            public RFuture<V> get() {
                return RedissonMapCacheReactive.this.mapCache.putIfAbsentAsync(key, value, ttl, unit);
            }
        });
    }

    @Override
    public Publisher<Boolean> remove(final Object key, final Object value) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonMapCacheReactive.this.mapCache.removeAsync(key, value);
            }
        });
    }

    @Override
    public Publisher<V> get(final K key) {
        return this.reactive(new Supplier<RFuture<V>>(){

            @Override
            public RFuture<V> get() {
                return RedissonMapCacheReactive.this.mapCache.getAsync(key);
            }
        });
    }

    @Override
    public Publisher<V> put(final K key, final V value, final long ttl, final TimeUnit unit) {
        return this.reactive(new Supplier<RFuture<V>>(){

            @Override
            public RFuture<V> get() {
                return RedissonMapCacheReactive.this.mapCache.putAsync(key, value, ttl, unit);
            }
        });
    }

    @Override
    public Publisher<V> remove(final K key) {
        return this.reactive(new Supplier<RFuture<V>>(){

            @Override
            public RFuture<V> get() {
                return RedissonMapCacheReactive.this.mapCache.removeAsync(key);
            }
        });
    }

    @Override
    public Publisher<Long> fastRemove(final K ... keys) {
        return this.reactive(new Supplier<RFuture<Long>>(){

            @Override
            public RFuture<Long> get() {
                return RedissonMapCacheReactive.this.mapCache.fastRemoveAsync(keys);
            }
        });
    }

    @Override
    public Publisher<MapScanResult<Object, Object>> scanIteratorReactive(final RedisClient client, final long startPos, final String pattern, final int count) {
        return this.reactive(new Supplier<RFuture<MapScanResult<Object, Object>>>(){

            @Override
            public RFuture<MapScanResult<Object, Object>> get() {
                return ((RedissonMapCache)RedissonMapCacheReactive.this.mapCache).scanIteratorAsync(RedissonMapCacheReactive.this.getName(), client, startPos, pattern, count);
            }
        });
    }

    @Override
    public Publisher<Boolean> delete() {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonMapCacheReactive.this.mapCache.deleteAsync();
            }
        });
    }

    @Override
    public Publisher<Boolean> expire(final long timeToLive, final TimeUnit timeUnit) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonMapCacheReactive.this.mapCache.expireAsync(timeToLive, timeUnit);
            }
        });
    }

    @Override
    public Publisher<Boolean> expireAt(final long timestamp) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonMapCacheReactive.this.mapCache.expireAtAsync(timestamp);
            }
        });
    }

    @Override
    public Publisher<Boolean> clearExpire() {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonMapCacheReactive.this.mapCache.clearExpireAsync();
            }
        });
    }

    @Override
    public Publisher<Void> putAll(final Map<? extends K, ? extends V> map) {
        return this.reactive(new Supplier<RFuture<Void>>(){

            @Override
            public RFuture<Void> get() {
                return RedissonMapCacheReactive.this.mapCache.putAllAsync(map);
            }
        });
    }

    @Override
    public Publisher<V> addAndGet(final K key, final Number delta) {
        return this.reactive(new Supplier<RFuture<V>>(){

            @Override
            public RFuture<V> get() {
                return RedissonMapCacheReactive.this.mapCache.addAndGetAsync(key, delta);
            }
        });
    }

    @Override
    public Publisher<Boolean> fastPut(final K key, final V value) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonMapCacheReactive.this.mapCache.fastPutAsync(key, value);
            }
        });
    }

    @Override
    public Publisher<V> put(final K key, final V value) {
        return this.reactive(new Supplier<RFuture<V>>(){

            @Override
            public RFuture<V> get() {
                return RedissonMapCacheReactive.this.mapCache.putAsync(key, value);
            }
        });
    }

    @Override
    public Publisher<V> replace(final K key, final V value) {
        return this.reactive(new Supplier<RFuture<V>>(){

            @Override
            public RFuture<V> get() {
                return RedissonMapCacheReactive.this.mapCache.replaceAsync(key, value);
            }
        });
    }

    @Override
    public Publisher<Boolean> replace(final K key, final V oldValue, final V newValue) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonMapCacheReactive.this.mapCache.replaceAsync(key, oldValue, newValue);
            }
        });
    }

    @Override
    public Publisher<V> putIfAbsent(final K key, final V value) {
        return this.reactive(new Supplier<RFuture<V>>(){

            @Override
            public RFuture<V> get() {
                return RedissonMapCacheReactive.this.mapCache.putIfAbsentAsync(key, value);
            }
        });
    }

    @Override
    public Publisher<Map.Entry<K, V>> entryIterator() {
        return this.entryIterator(null);
    }

    @Override
    public Publisher<Map.Entry<K, V>> entryIterator(int count) {
        return this.entryIterator(null, count);
    }

    @Override
    public Publisher<Map.Entry<K, V>> entryIterator(String pattern) {
        return this.entryIterator(pattern, 10);
    }

    @Override
    public Publisher<Map.Entry<K, V>> entryIterator(String pattern, int count) {
        return new RedissonMapReactiveIterator(this, pattern, count).stream();
    }

    @Override
    public Publisher<V> valueIterator() {
        return this.valueIterator(null);
    }

    @Override
    public Publisher<V> valueIterator(String pattern) {
        return this.valueIterator(pattern, 10);
    }

    @Override
    public Publisher<V> valueIterator(int count) {
        return this.valueIterator(null, count);
    }

    @Override
    public Publisher<V> valueIterator(String pattern, int count) {
        return new RedissonMapReactiveIterator<K, V, V>(this, pattern, count){

            @Override
            V getValue(Map.Entry<Object, Object> entry) {
                return entry.getValue();
            }
        }.stream();
    }

    @Override
    public Publisher<K> keyIterator() {
        return this.keyIterator(null);
    }

    @Override
    public Publisher<K> keyIterator(String pattern) {
        return this.keyIterator(pattern, 10);
    }

    @Override
    public Publisher<K> keyIterator(int count) {
        return this.keyIterator(null, count);
    }

    @Override
    public Publisher<K> keyIterator(String pattern, int count) {
        return new RedissonMapReactiveIterator<K, V, K>(this, pattern, count){

            @Override
            K getValue(Map.Entry<Object, Object> entry) {
                return entry.getKey();
            }
        }.stream();
    }

    @Override
    public Publisher<Integer> size() {
        return this.reactive(new Supplier<RFuture<Integer>>(){

            @Override
            public RFuture<Integer> get() {
                return RedissonMapCacheReactive.this.mapCache.sizeAsync();
            }
        });
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Map) {
            Map m = (Map)o;
            if (m.size() != Streams.create(this.size()).next().poll().intValue()) {
                return false;
            }
            return Streams.create(this.entryIterator()).map(this.mapFunction(m)).reduce(true, this.booleanAnd()).next().poll();
        }
        if (o instanceof RMapReactive) {
            RMapReactive m = (RMapReactive)o;
            if (Streams.create(m.size()).next().poll() != Streams.create(this.size()).next().poll()) {
                return false;
            }
            return Streams.create(this.entryIterator()).map(this.mapFunction(m)).reduce(true, this.booleanAnd()).next().poll();
        }
        return true;
    }

    private BiFunction<Boolean, Boolean, Boolean> booleanAnd() {
        return new BiFunction<Boolean, Boolean, Boolean>(){

            @Override
            public Boolean apply(Boolean t, Boolean u) {
                return t & u;
            }
        };
    }

    private Function<Map.Entry<K, V>, Boolean> mapFunction(final Map<?, ?> m) {
        return new Function<Map.Entry<K, V>, Boolean>(){

            @Override
            public Boolean apply(Map.Entry<K, V> e) {
                Object key = e.getKey();
                Object value = e.getValue();
                if (value == null ? m.get(key) != null || !m.containsKey(key) : !value.equals(m.get(key))) {
                    return false;
                }
                return true;
            }
        };
    }

    private Function<Map.Entry<K, V>, Boolean> mapFunction(final RMapReactive<Object, Object> m) {
        return new Function<Map.Entry<K, V>, Boolean>(){

            @Override
            public Boolean apply(Map.Entry<K, V> e) {
                Object key = e.getKey();
                Object value = e.getValue();
                if (value == null ? Streams.create(m.get(key)).next().poll() != null || Streams.create(m.containsKey(key)).next().poll() == false : !value.equals(Streams.create(m.get(key)).next().poll())) {
                    return false;
                }
                return true;
            }
        };
    }

    public int hashCode() {
        return Streams.create(this.entryIterator()).map(new Function<Map.Entry<K, V>, Integer>(){

            @Override
            public Integer apply(Map.Entry<K, V> t) {
                return t.hashCode();
            }
        }).reduce(0, new BiFunction<Integer, Integer, Integer>(){

            @Override
            public Integer apply(Integer t, Integer u) {
                return t + u;
            }
        }).next().poll();
    }

    @Override
    public Publisher<Void> loadAll(final boolean replaceExistingValues, final int parallelism) {
        return this.reactive(new Supplier<RFuture<Void>>(){

            @Override
            public RFuture<Void> get() {
                return RedissonMapCacheReactive.this.mapCache.loadAllAsync(replaceExistingValues, parallelism);
            }
        });
    }

    @Override
    public Publisher<Void> loadAll(final Set<? extends K> keys, final boolean replaceExistingValues, final int parallelism) {
        return this.reactive(new Supplier<RFuture<Void>>(){

            @Override
            public RFuture<Void> get() {
                return RedissonMapCacheReactive.this.mapCache.loadAllAsync(keys, replaceExistingValues, parallelism);
            }
        });
    }

    @Override
    public Publisher<Integer> valueSize(final K key) {
        return this.reactive(new Supplier<RFuture<Integer>>(){

            @Override
            public RFuture<Integer> get() {
                return RedissonMapCacheReactive.this.mapCache.valueSizeAsync(key);
            }
        });
    }

    @Override
    public Publisher<Boolean> fastPutIfAbsent(final K key, final V value) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonMapCacheReactive.this.mapCache.fastPutIfAbsentAsync(key, value);
            }
        });
    }

    @Override
    public Publisher<Set<K>> readAllKeySet() {
        return this.reactive(new Supplier<RFuture<Set<K>>>(){

            @Override
            public RFuture<Set<K>> get() {
                return RedissonMapCacheReactive.this.mapCache.readAllKeySetAsync();
            }
        });
    }

    @Override
    public Publisher<Collection<V>> readAllValues() {
        return this.reactive(new Supplier<RFuture<Collection<V>>>(){

            @Override
            public RFuture<Collection<V>> get() {
                return RedissonMapCacheReactive.this.mapCache.readAllValuesAsync();
            }
        });
    }

    @Override
    public Publisher<Set<Map.Entry<K, V>>> readAllEntrySet() {
        return this.reactive(new Supplier<RFuture<Set<Map.Entry<K, V>>>>(){

            @Override
            public RFuture<Set<Map.Entry<K, V>>> get() {
                return RedissonMapCacheReactive.this.mapCache.readAllEntrySetAsync();
            }
        });
    }

    @Override
    public Publisher<Map<K, V>> readAllMap() {
        return this.reactive(new Supplier<RFuture<Map<K, V>>>(){

            @Override
            public RFuture<Map<K, V>> get() {
                return RedissonMapCacheReactive.this.mapCache.readAllMapAsync();
            }
        });
    }

    @Override
    public Publisher<V> putIfAbsent(final K key, final V value, final long ttl, final TimeUnit ttlUnit, final long maxIdleTime, final TimeUnit maxIdleUnit) {
        return this.reactive(new Supplier<RFuture<V>>(){

            @Override
            public RFuture<V> get() {
                return RedissonMapCacheReactive.this.mapCache.putIfAbsentAsync(key, value, ttl, ttlUnit, maxIdleTime, maxIdleUnit);
            }
        });
    }

    @Override
    public Publisher<V> put(final K key, final V value, final long ttl, final TimeUnit ttlUnit, final long maxIdleTime, final TimeUnit maxIdleUnit) {
        return this.reactive(new Supplier<RFuture<V>>(){

            @Override
            public RFuture<V> get() {
                return RedissonMapCacheReactive.this.mapCache.putAsync(key, value, ttl, ttlUnit, maxIdleTime, maxIdleUnit);
            }
        });
    }

    @Override
    public Publisher<Boolean> fastPut(final K key, final V value, final long ttl, final TimeUnit unit) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonMapCacheReactive.this.mapCache.fastPutAsync(key, value, ttl, unit);
            }
        });
    }

    @Override
    public Publisher<Boolean> fastPut(final K key, final V value, final long ttl, final TimeUnit ttlUnit, final long maxIdleTime, final TimeUnit maxIdleUnit) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonMapCacheReactive.this.mapCache.fastPutAsync(key, value, ttl, ttlUnit, maxIdleTime, maxIdleUnit);
            }
        });
    }

    @Override
    public Publisher<Boolean> fastPutIfAbsent(final K key, final V value, final long ttl, final TimeUnit ttlUnit, final long maxIdleTime, final TimeUnit maxIdleUnit) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonMapCacheReactive.this.mapCache.fastPutIfAbsentAsync(key, value, ttl, ttlUnit, maxIdleTime, maxIdleUnit);
            }
        });
    }
}

