/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction.operation.set;

import org.redisson.RedissonSetCache;
import org.redisson.api.RObject;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.transaction.operation.TransactionalOperation;

public class RemoveCacheOperation
extends TransactionalOperation {
    private Object value;

    public RemoveCacheOperation(RObject set, Object value) {
        this(set.getName(), set.getCodec(), value);
    }

    public RemoveCacheOperation(String name, Codec codec, Object value) {
        super(name, codec);
        this.value = value;
    }

    @Override
    public void commit(CommandAsyncExecutor commandExecutor) {
        RedissonSetCache<Object> set = new RedissonSetCache<Object>(this.codec, null, commandExecutor, this.name, null);
        set.removeAsync(this.value);
        set.getLock(this.value).unlockAsync();
    }

    @Override
    public void rollback(CommandAsyncExecutor commandExecutor) {
        RedissonSetCache<Object> set = new RedissonSetCache<Object>(this.codec, null, commandExecutor, this.name, null);
        set.getLock(this.value).unlockAsync();
    }

    public Object getValue() {
        return this.value;
    }
}

