/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction.operation.map;

import org.redisson.RedissonMap;
import org.redisson.RedissonMapCache;
import org.redisson.api.RMap;
import org.redisson.api.RMapCache;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.transaction.operation.TransactionalOperation;

public abstract class MapOperation
extends TransactionalOperation {
    Object key;
    Object value;
    Object oldValue;
    RMap<?, ?> map;

    public MapOperation() {
    }

    public MapOperation(RMap<?, ?> map, Object key, Object value) {
        this(map, key, value, null);
    }

    public MapOperation(RMap<?, ?> map, Object key, Object value, Object oldValue) {
        super(map.getName(), map.getCodec());
        this.map = map;
        this.key = key;
        this.value = value;
        this.oldValue = oldValue;
    }

    public Object getKey() {
        return this.key;
    }

    public RMap<?, ?> getMap() {
        return this.map;
    }

    @Override
    public final void commit(CommandAsyncExecutor commandExecutor) {
        RMap<Object, Object> map = this.getMap(commandExecutor);
        this.commit(map);
        map.getLock(this.key).unlockAsync();
    }

    protected RMap<Object, Object> getMap(CommandAsyncExecutor commandExecutor) {
        if (this.map instanceof RMapCache) {
            return new RedissonMapCache<Object, Object>(this.codec, null, commandExecutor, this.name, null, null);
        }
        return new RedissonMap<Object, Object>(this.codec, commandExecutor, this.name, null, null);
    }

    @Override
    public void rollback(CommandAsyncExecutor commandExecutor) {
        RMap<Object, Object> map = this.getMap(commandExecutor);
        map.getLock(this.key).unlockAsync();
    }

    protected abstract void commit(RMap<Object, Object> var1);

    public Object getValue() {
        return this.value;
    }

    public Object getOldValue() {
        return this.oldValue;
    }
}

