/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.redisson.RedissonMapCache;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.api.RReadWriteLock;
import org.redisson.api.RedissonClient;
import org.redisson.api.mapreduce.RMapReduce;
import org.redisson.client.RedisClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.decoder.MapScanResult;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.eviction.EvictionScheduler;
import org.redisson.transaction.BaseTransactionalMapCache;
import org.redisson.transaction.operation.TransactionalOperation;

public class RedissonTransactionalMapCache<K, V>
extends RedissonMapCache<K, V> {
    private final BaseTransactionalMapCache<K, V> transactionalMap;
    private final AtomicBoolean executed;

    public RedissonTransactionalMapCache(CommandAsyncExecutor commandExecutor, String name, List<TransactionalOperation> operations, long timeout, AtomicBoolean executed) {
        super((EvictionScheduler)null, commandExecutor, name, (RedissonClient)null, null);
        this.executed = executed;
        RedissonMapCache innerMap = new RedissonMapCache(null, commandExecutor, name, null, null);
        this.transactionalMap = new BaseTransactionalMapCache(timeout, operations, innerMap);
    }

    public RedissonTransactionalMapCache(Codec codec, CommandAsyncExecutor commandExecutor, String name, List<TransactionalOperation> operations, long timeout, AtomicBoolean executed) {
        super(codec, null, commandExecutor, name, null, null);
        this.executed = executed;
        RedissonMapCache innerMap = new RedissonMapCache(codec, null, commandExecutor, name, null, null);
        this.transactionalMap = new BaseTransactionalMapCache(timeout, operations, innerMap);
    }

    @Override
    public RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit) {
        throw new UnsupportedOperationException("expire method is not supported in transaction");
    }

    @Override
    public RFuture<Boolean> expireAtAsync(Date timestamp) {
        throw new UnsupportedOperationException("expireAt method is not supported in transaction");
    }

    @Override
    public RFuture<Boolean> expireAtAsync(long timestamp) {
        throw new UnsupportedOperationException("expireAt method is not supported in transaction");
    }

    @Override
    public RFuture<Boolean> clearExpireAsync() {
        throw new UnsupportedOperationException("clearExpire method is not supported in transaction");
    }

    @Override
    public RFuture<Boolean> moveAsync(int database) {
        throw new UnsupportedOperationException("moveAsync method is not supported in transaction");
    }

    @Override
    public RFuture<Void> migrateAsync(String host, int port, int database, long timeout) {
        throw new UnsupportedOperationException("migrateAsync method is not supported in transaction");
    }

    @Override
    public RFuture<Boolean> touchAsync() {
        this.checkState();
        return this.transactionalMap.touchAsync(this.commandExecutor);
    }

    @Override
    public RFuture<Boolean> isExistsAsync() {
        this.checkState();
        return this.transactionalMap.isExistsAsync();
    }

    @Override
    public RFuture<Boolean> unlinkAsync() {
        return this.transactionalMap.unlinkAsync(this.commandExecutor);
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        this.checkState();
        return this.transactionalMap.deleteAsync(this.commandExecutor);
    }

    @Override
    public RFuture<V> putIfAbsentAsync(K key, V value, long ttl, TimeUnit ttlUnit, long maxIdleTime, TimeUnit maxIdleUnit) {
        return this.transactionalMap.putIfAbsentAsync(key, value, ttl, ttlUnit, maxIdleTime, maxIdleUnit);
    }

    @Override
    public RFuture<Boolean> fastPutOperationAsync(K key, V value, long ttl, TimeUnit ttlUnit, long maxIdleTime, TimeUnit maxIdleUnit) {
        return this.transactionalMap.fastPutOperationAsync(key, value, ttl, ttlUnit, maxIdleTime, maxIdleUnit);
    }

    @Override
    public RFuture<V> putOperationAsync(K key, V value, long ttlTimeout, long maxIdleTimeout, long maxIdleDelta) {
        return this.transactionalMap.putOperationAsync(key, value, ttlTimeout, maxIdleTimeout, maxIdleDelta);
    }

    @Override
    public RFuture<Boolean> fastPutIfAbsentAsync(K key, V value, long ttl, TimeUnit ttlUnit, long maxIdleTime, TimeUnit maxIdleUnit) {
        return this.transactionalMap.fastPutIfAbsentAsync(key, value, ttl, ttlUnit, maxIdleTime, maxIdleUnit);
    }

    @Override
    public RFuture<Long> remainTimeToLiveAsync() {
        throw new UnsupportedOperationException("remainTimeToLiveAsync method is not supported in transaction");
    }

    @Override
    public RFuture<Void> setMaxSizeAsync(int maxSize) {
        throw new UnsupportedOperationException("setMaxSize method is not supported in transaction");
    }

    @Override
    public RFuture<Boolean> trySetMaxSizeAsync(int maxSize) {
        throw new UnsupportedOperationException("trySetMaxSize method is not supported in transaction");
    }

    @Override
    public <KOut, VOut> RMapReduce<K, V, KOut, VOut> mapReduce() {
        throw new UnsupportedOperationException("mapReduce method is not supported in transaction");
    }

    @Override
    public MapScanResult<Object, Object> scanIterator(String name, RedisClient client, long startPos, String pattern, int count) {
        this.checkState();
        return this.transactionalMap.scanIterator(name, client, startPos, pattern, count);
    }

    @Override
    public RFuture<Boolean> containsKeyAsync(Object key) {
        this.checkState();
        return this.transactionalMap.containsKeyAsync(key);
    }

    @Override
    public RFuture<Boolean> containsValueAsync(Object value) {
        this.checkState();
        return this.transactionalMap.containsValueAsync(value);
    }

    @Override
    protected RFuture<V> addAndGetOperationAsync(K key, Number value) {
        this.checkState();
        return this.transactionalMap.addAndGetOperationAsync(key, value);
    }

    @Override
    protected RFuture<V> putIfAbsentOperationAsync(K key, V value) {
        this.checkState();
        return this.transactionalMap.putIfAbsentOperationAsync(key, value);
    }

    @Override
    protected RFuture<V> putOperationAsync(K key, V value) {
        this.checkState();
        return this.transactionalMap.putOperationAsync(key, value);
    }

    @Override
    protected RFuture<Boolean> fastPutIfAbsentOperationAsync(K key, V value) {
        this.checkState();
        return this.transactionalMap.fastPutIfAbsentOperationAsync(key, value);
    }

    @Override
    protected RFuture<Boolean> fastPutOperationAsync(K key, V value) {
        this.checkState();
        return this.transactionalMap.fastPutOperationAsync(key, value);
    }

    @Override
    protected RFuture<Long> fastRemoveOperationAsync(K ... keys) {
        this.checkState();
        return this.transactionalMap.fastRemoveOperationAsync(keys);
    }

    @Override
    public RFuture<Integer> valueSizeAsync(K key) {
        this.checkState();
        return this.transactionalMap.valueSizeAsync(key);
    }

    @Override
    public RFuture<V> getOperationAsync(K key) {
        this.checkState();
        return this.transactionalMap.getOperationAsync(key);
    }

    @Override
    public RFuture<Set<K>> readAllKeySetAsync() {
        this.checkState();
        return this.transactionalMap.readAllKeySetAsync();
    }

    @Override
    public RFuture<Set<Map.Entry<K, V>>> readAllEntrySetAsync() {
        this.checkState();
        return this.transactionalMap.readAllEntrySetAsync();
    }

    @Override
    public RFuture<Collection<V>> readAllValuesAsync() {
        this.checkState();
        return this.transactionalMap.readAllValuesAsync();
    }

    @Override
    public RFuture<Map<K, V>> readAllMapAsync() {
        this.checkState();
        return this.transactionalMap.readAllMapAsync();
    }

    @Override
    public RFuture<Map<K, V>> getAllOperationAsync(Set<K> keys) {
        this.checkState();
        return this.transactionalMap.getAllOperationAsync(keys);
    }

    @Override
    protected RFuture<V> removeOperationAsync(K key) {
        this.checkState();
        return this.transactionalMap.removeOperationAsync(key);
    }

    @Override
    protected RFuture<Boolean> removeOperationAsync(Object key, Object value) {
        this.checkState();
        return this.transactionalMap.removeOperationAsync(key, value);
    }

    @Override
    protected RFuture<Void> putAllOperationAsync(Map<? extends K, ? extends V> entries) {
        this.checkState();
        return this.transactionalMap.putAllOperationAsync(entries);
    }

    @Override
    protected RFuture<Boolean> replaceOperationAsync(K key, V oldValue, V newValue) {
        this.checkState();
        return this.transactionalMap.replaceOperationAsync(key, oldValue, newValue);
    }

    @Override
    protected RFuture<V> replaceOperationAsync(K key, V value) {
        this.checkState();
        return this.transactionalMap.replaceOperationAsync(key, value);
    }

    protected void checkState() {
        if (this.executed.get()) {
            throw new IllegalStateException("Unable to execute operation. Transaction is in finished state!");
        }
    }

    @Override
    public RFuture<Void> loadAllAsync(boolean replaceExistingValues, int parallelism) {
        throw new UnsupportedOperationException("loadAll method is not supported in transaction");
    }

    @Override
    public RFuture<Void> loadAllAsync(Set<? extends K> keys, boolean replaceExistingValues, int parallelism) {
        throw new UnsupportedOperationException("loadAll method is not supported in transaction");
    }

    @Override
    public RLock getLock(K key) {
        throw new UnsupportedOperationException("getLock method is not supported in transaction");
    }

    @Override
    public RReadWriteLock getReadWriteLock(K key) {
        throw new UnsupportedOperationException("getReadWriteLock method is not supported in transaction");
    }
}

