/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.AbstractMap;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.redisson.client.RedisClient;
import org.redisson.client.protocol.decoder.MapScanResult;
import org.redisson.client.protocol.decoder.ScanObjectEntry;
import org.redisson.reactive.MapReactive;
import reactor.rx.Stream;
import reactor.rx.subscription.ReactiveSubscription;

public class RedissonMapReactiveIterator<K, V, M> {
    private final MapReactive<K, V> map;

    public RedissonMapReactiveIterator(MapReactive<K, V> map) {
        this.map = map;
    }

    public Publisher<M> stream() {
        return new Stream<M>(){

            @Override
            public void subscribe(Subscriber<? super M> t) {
                t.onSubscribe(new ReactiveSubscription<M>(this, t){
                    private long nextIterPos;
                    private RedisClient client;
                    private long currentIndex;
                    {
                        this.nextIterPos = 0L;
                    }

                    @Override
                    protected void onRequest(long n) {
                        this.currentIndex = n;
                        this.nextValues();
                    }

                    protected void nextValues() {
                        final 1 m = this;
                        RedissonMapReactiveIterator.this.map.scanIteratorReactive(this.client, this.nextIterPos).subscribe(new Subscriber<MapScanResult<ScanObjectEntry, ScanObjectEntry>>(){

                            @Override
                            public void onSubscribe(Subscription s) {
                                s.request(Long.MAX_VALUE);
                            }

                            @Override
                            public void onNext(MapScanResult<ScanObjectEntry, ScanObjectEntry> res) {
                                if (currentIndex == 0L) {
                                    client = null;
                                    nextIterPos = 0L;
                                    return;
                                }
                                client = res.getRedisClient();
                                nextIterPos = res.getPos();
                                for (Map.Entry<ScanObjectEntry, ScanObjectEntry> entry : res.getMap().entrySet()) {
                                    Object val = RedissonMapReactiveIterator.this.getValue(entry);
                                    m.onNext(val);
                                    currentIndex--;
                                    if (currentIndex != 0L) continue;
                                    m.onComplete();
                                    return;
                                }
                                if (res.getPos() == 0L) {
                                    currentIndex = 0L;
                                    m.onComplete();
                                }
                            }

                            @Override
                            public void onError(Throwable error) {
                                m.onError(error);
                            }

                            @Override
                            public void onComplete() {
                                if (currentIndex == 0L) {
                                    return;
                                }
                                this.nextValues();
                            }
                        });
                    }
                });
            }
        };
    }

    M getValue(final Map.Entry<ScanObjectEntry, ScanObjectEntry> entry) {
        return (M)new AbstractMap.SimpleEntry<K, V>(entry.getKey().getObj(), entry.getValue().getObj()){

            @Override
            public V setValue(V value) {
                Publisher publisher = RedissonMapReactiveIterator.this.map.put(((ScanObjectEntry)entry.getKey()).getObj(), value);
                return ((Stream)publisher).next().poll();
            }
        };
    }
}

