/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.redisson.client.RedisClient;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.client.protocol.decoder.ScanObjectEntry;
import reactor.rx.Stream;
import reactor.rx.subscription.ReactiveSubscription;

public abstract class SetReactiveIterator<V>
extends Stream<V> {
    @Override
    public void subscribe(Subscriber<? super V> t) {
        t.onSubscribe(new ReactiveSubscription<V>(this, t){
            private long nextIterPos;
            private RedisClient client;
            private boolean finished;

            @Override
            protected void onRequest(long n) {
                this.nextValues();
            }

            protected void nextValues() {
                final 1 m = this;
                SetReactiveIterator.this.scanIteratorReactive(this.client, this.nextIterPos).subscribe(new Subscriber<ListScanResult<ScanObjectEntry>>(){

                    @Override
                    public void onSubscribe(Subscription s) {
                        s.request(Long.MAX_VALUE);
                    }

                    @Override
                    public void onNext(ListScanResult<ScanObjectEntry> res) {
                        if (finished) {
                            client = null;
                            nextIterPos = 0L;
                            return;
                        }
                        client = res.getRedisClient();
                        nextIterPos = res.getPos();
                        for (ScanObjectEntry val : res.getValues()) {
                            m.onNext(val.getObj());
                        }
                        if (res.getPos() == 0L) {
                            finished = true;
                            m.onComplete();
                        }
                    }

                    @Override
                    public void onError(Throwable error) {
                        m.onError(error);
                    }

                    @Override
                    public void onComplete() {
                        if (finished) {
                            return;
                        }
                        this.nextValues();
                    }
                });
            }
        });
    }

    protected abstract Publisher<ListScanResult<ScanObjectEntry>> scanIteratorReactive(RedisClient var1, long var2);
}

