/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.executor;

import java.util.Arrays;
import java.util.concurrent.ConcurrentMap;
import org.redisson.api.RFuture;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandExecutor;
import org.redisson.executor.TasksService;
import org.redisson.remote.RemoteServiceRequest;
import org.redisson.remote.RequestId;
import org.redisson.remote.ResponseEntry;

public class ScheduledTasksService
extends TasksService {
    private RequestId requestId;
    private String schedulerQueueName;
    private String schedulerChannelName;

    public ScheduledTasksService(Codec codec, RedissonClient redisson, String name, CommandExecutor commandExecutor, String redissonId, ConcurrentMap<String, ResponseEntry> responses) {
        super(codec, redisson, name, commandExecutor, redissonId, responses);
    }

    public void setRequestId(RequestId requestId) {
        this.requestId = requestId;
    }

    public void setSchedulerChannelName(String schedulerChannelName) {
        this.schedulerChannelName = schedulerChannelName;
    }

    public void setSchedulerQueueName(String scheduledQueueName) {
        this.schedulerQueueName = scheduledQueueName;
    }

    @Override
    protected RFuture<Boolean> addAsync(String requestQueueName, RemoteServiceRequest request) {
        int requestIndex = 0;
        if ("scheduleCallable".equals(request.getMethodName()) || "scheduleRunnable".equals(request.getMethodName())) {
            requestIndex = 4;
        }
        if ("scheduleAtFixedRate".equals(request.getMethodName()) || "scheduleWithFixedDelay".equals(request.getMethodName()) || "schedule".equals(request.getMethodName())) {
            requestIndex = 6;
        }
        request.getArgs()[requestIndex] = request.getId();
        Long startTime = (Long)request.getArgs()[3];
        if (this.requestId != null) {
            return this.commandExecutor.evalWriteAsync(this.name, (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('exists', KEYS[2]) == 0 and redis.call('hexists', KEYS[5], ARGV[2]) == 1 then redis.call('zadd', KEYS[3], ARGV[1], ARGV[2]);redis.call('hset', KEYS[5], ARGV[2], ARGV[3]);redis.call('incr', KEYS[1]);local v = redis.call('zrange', KEYS[3], 0, 0); if v[1] == ARGV[2] then redis.call('publish', KEYS[4], ARGV[1]); end return 1;end;return 0;", Arrays.asList(this.tasksCounterName, this.statusName, this.schedulerQueueName, this.schedulerChannelName, this.tasksName), startTime, request.getId(), this.encode(request));
        }
        return this.commandExecutor.evalWriteAsync(this.name, (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('exists', KEYS[2]) == 0 then redis.call('zadd', KEYS[3], ARGV[1], ARGV[2]);redis.call('hset', KEYS[5], ARGV[2], ARGV[3]);redis.call('incr', KEYS[1]);local v = redis.call('zrange', KEYS[3], 0, 0); if v[1] == ARGV[2] then redis.call('publish', KEYS[4], ARGV[1]); end return 1;end;return 0;", Arrays.asList(this.tasksCounterName, this.statusName, this.schedulerQueueName, this.schedulerChannelName, this.tasksName), startTime, request.getId(), this.encode(request));
    }

    @Override
    protected RFuture<Boolean> removeAsync(String requestQueueName, RequestId taskId) {
        return this.commandExecutor.evalWriteAsync(this.name, (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('zrem', KEYS[2], ARGV[1]) > 0 then redis.call('hdel', KEYS[6], ARGV[1]); if redis.call('decr', KEYS[3]) == 0 then redis.call('del', KEYS[3]);if redis.call('get', KEYS[4]) == ARGV[2] then redis.call('set', KEYS[4], ARGV[3]);redis.call('publish', KEYS[5], ARGV[3]);end;end;return 1;end;local task = redis.call('hget', KEYS[6], ARGV[1]); if task ~= false and redis.call('lrem', KEYS[1], 1, ARGV[1]) > 0 then redis.call('hdel', KEYS[6], ARGV[1]); if redis.call('decr', KEYS[3]) == 0 then redis.call('del', KEYS[3]);if redis.call('get', KEYS[4]) == ARGV[2] then redis.call('set', KEYS[4], ARGV[3]);redis.call('publish', KEYS[5], ARGV[3]);end;end;return 1;end;redis.call('hdel', KEYS[6], ARGV[1]); return 0;", Arrays.asList(requestQueueName, this.schedulerQueueName, this.tasksCounterName, this.statusName, this.terminationTopicName, this.tasksName), taskId.toString(), 1, 2);
    }

    @Override
    protected RequestId generateRequestId() {
        if (this.requestId == null) {
            return super.generateRequestId();
        }
        return this.requestId;
    }
}

