/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.action.combination;

import java.util.Arrays;
import java.util.List;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Dispatcher;
import reactor.fn.Function;
import reactor.fn.tuple.Tuple;
import reactor.rx.action.combination.FanInAction;
import reactor.rx.action.combination.FanInSubscription;
import reactor.rx.subscription.PushSubscription;

public final class ZipAction<O, V, TUPLE extends Tuple>
extends FanInAction<O, Zippable<O>, V, InnerSubscriber<O, V>> {
    private static final Object EMPTY_ZIPPED_DATA = new Object();
    final Function<TUPLE, ? extends V> accumulator;
    int index = 0;
    int count = 0;
    Object[] toZip;

    public static <TUPLE extends Tuple, V> Function<TUPLE, List<V>> joinZipper() {
        return new Function<TUPLE, List<V>>(){

            @Override
            public List<V> apply(TUPLE ts) {
                return Arrays.asList(((Tuple)ts).toArray());
            }
        };
    }

    public ZipAction(Dispatcher dispatcher, Function<TUPLE, ? extends V> accumulator, List<? extends Publisher<? extends O>> composables) {
        super(dispatcher, composables);
        this.accumulator = accumulator;
        this.toZip = new Object[composables != null ? composables.size() : 1];
        this.capacity(this.toZip.length);
    }

    @Override
    protected void doOnSubscribe(Subscription subscription) {
        if (this.status.compareAndSet(0, 1) && this.publishers != null) {
            for (Publisher publisher : this.publishers) {
                this.addPublisher(publisher);
            }
        }
    }

    protected void broadcastTuple(boolean isFinishing) {
        long capacity = this.capacity;
        if ((long)this.count >= capacity) {
            if (!this.checkAllFilled()) {
                return;
            }
            this.count = 0;
            Object[] _toZip = this.toZip;
            this.toZip = new Object[this.toZip.length];
            V res = this.accumulator.apply(Tuple.of(_toZip));
            if (res != null) {
                this.broadcastNext(res);
                if (!isFinishing && this.upstreamSubscription.pendingRequestSignals() > 0L) {
                    this.dispatcher.dispatch(capacity, this.upstreamSubscription, null);
                }
            }
        }
        if (isFinishing) {
            this.broadcastComplete();
        }
    }

    @Override
    protected void requestUpstream(long capacity, boolean terminated, long elements) {
        long upstream = this.innerSubscriptions.runningComposables;
        long l = upstream == 0L ? elements : (upstream = upstream * elements < 0L ? Long.MAX_VALUE : upstream * elements);
        if (this.publishers != null && this.innerSubscriptions.pendingRequestSignals() > 0L) {
            this.innerSubscriptions.updatePendingRequests(upstream);
        } else {
            this.requestMore(upstream);
            if (this.dynamicMergeAction != null) {
                this.dynamicMergeAction.requestUpstream(capacity, terminated, elements);
            }
        }
    }

    private boolean checkAllFilled() {
        for (int i = 0; i < this.toZip.length; ++i) {
            if (this.toZip[i] != null) continue;
            return false;
        }
        return true;
    }

    @Override
    protected FanInSubscription<O, Zippable<O>, V, InnerSubscriber<O, V>> createFanInSubscription() {
        return new ZipSubscription(this);
    }

    @Override
    protected PushSubscription<Zippable<O>> createTrackingSubscription(Subscription subscription) {
        return this.innerSubscriptions;
    }

    @Override
    protected void doNext(Zippable<O> ev) {
        ++this.count;
        this.toZip[ev.index] = ev.data == null ? EMPTY_ZIPPED_DATA : ev.data;
        this.broadcastTuple(false);
    }

    @Override
    protected void doComplete() {
        this.broadcastTuple(true);
    }

    protected InnerSubscriber<O, V> createSubscriber() {
        return new InnerSubscriber(this, this.index++);
    }

    @Override
    public String toString() {
        String formatted = super.toString();
        for (int i = 0; i < this.toZip.length; ++i) {
            if (this.toZip[i] == null) continue;
            formatted = formatted + "(" + i + "):" + this.toZip[i] + ",";
        }
        return formatted.substring(0, this.count > 0 ? formatted.length() - 1 : formatted.length());
    }

    public static final class Zippable<O> {
        final int index;
        final O data;

        public Zippable(int index, O data) {
            this.index = index;
            this.data = data;
        }

        public String toString() {
            return "Zippable{index=" + this.index + ", data=" + this.data + '}';
        }
    }

    private final class ZipSubscription
    extends FanInSubscription<O, Zippable<O>, V, InnerSubscriber<O, V>> {
        public ZipSubscription(Subscriber<? super Zippable<O>> subscriber) {
            super(subscriber);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean shouldRequestPendingSignals() {
            ZipSubscription zipSubscription = this;
            synchronized (zipSubscription) {
                return this.pendingRequestSignals > 0L && this.pendingRequestSignals != Long.MAX_VALUE && (long)ZipAction.this.count == this.maxCapacity;
            }
        }

        @Override
        public void request(long elements) {
            if (this.pendingRequestSignals == Long.MAX_VALUE) {
                super.parallelRequest(1L);
            } else {
                super.request(elements);
            }
        }

        @Override
        public void onNext(Zippable<O> ev) {
            if (ev.data != null) {
                super.onNext(ev);
            } else if (ZipAction.this.toZip.length > ev.index && ZipAction.this.toZip[ev.index] == null) {
                super.onComplete();
            }
        }
    }

    public static final class InnerSubscriber<O, V>
    extends FanInAction.InnerSubscriber<O, Zippable<O>, V> {
        final ZipAction<O, V, ?> outerAction;
        final int index;

        InnerSubscriber(ZipAction<O, V, ?> outerAction, int index) {
            super(outerAction);
            this.index = index;
            this.outerAction = outerAction;
        }

        @Override
        public void onSubscribe(Subscription subscription) {
            this.setSubscription(new FanInSubscription.InnerSubscription(subscription, this));
            int newSize = this.outerAction.innerSubscriptions.runningComposables;
            newSize = newSize == 0 ? 1 : newSize;
            this.outerAction.capacity(newSize);
            if (newSize > this.outerAction.toZip.length) {
                Object[] previousZip = this.outerAction.toZip;
                this.outerAction.toZip = new Object[newSize];
                System.arraycopy(previousZip, 0, this.outerAction.toZip, 0, newSize - 1);
            }
            if (this.pendingRequests > 0L) {
                this.pendingRequests = 0L;
                this.request(1L);
            }
            if (this.outerAction.dynamicMergeAction != null) {
                this.outerAction.dynamicMergeAction.decrementWip();
            }
        }

        @Override
        public void onComplete() {
            if (TERMINATE_UPDATER.compareAndSet(this, 0, 1)) {
                this.outerAction.innerSubscriptions.remove(this.sequenceId);
                this.outerAction.status.compareAndSet(1, 2);
                this.outerAction.capacity(this.outerAction.innerSubscriptions.runningComposables);
                if (FanInSubscription.RUNNING_COMPOSABLE_UPDATER.decrementAndGet(this.outerAction.innerSubscriptions) == 0) {
                    this.outerAction.innerSubscriptions.serialComplete();
                } else {
                    this.outerAction.innerSubscriptions.serialNext(new Zippable<Object>(this.index, null));
                }
            }
        }

        @Override
        public void request(long n) {
            super.request(1L);
        }

        @Override
        public void onNext(O ev) {
            if (--this.pendingRequests < 0L) {
                this.pendingRequests = 0L;
            }
            this.emittedSignals = 1L;
            if (this.outerAction.status.get() == 2 && TERMINATE_UPDATER.compareAndSet(this, 0, 1)) {
                this.outerAction.innerSubscriptions.remove(this.sequenceId);
                long left = FanInSubscription.RUNNING_COMPOSABLE_UPDATER.decrementAndGet(this.outerAction.innerSubscriptions);
                if (0L == left) {
                    this.outerAction.innerSubscriptions.serialNext(new Zippable<O>(this.index, ev));
                    this.outerAction.innerSubscriptions.serialComplete();
                    return;
                }
            }
            this.outerAction.innerSubscriptions.serialNext(new Zippable<O>(this.index, ev));
        }

        @Override
        public boolean isReactivePull(Dispatcher dispatcher, long producerCapacity) {
            return true;
        }

        @Override
        public long getCapacity() {
            return 1L;
        }

        @Override
        public String toString() {
            return "Zip.InnerSubscriber{index=" + this.index + ", " + "pending=" + this.pendingRequests + ", emitted=" + this.emittedSignals + "}";
        }
    }
}

