/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.codec;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import org.redisson.client.codec.Codec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;
import org.redisson.client.protocol.decoder.ScanObjectEntry;
import org.redisson.misc.Hash;
import org.redisson.misc.HashValue;

public class ScanCodec
implements Codec {
    private final Codec delegate;

    public ScanCodec(Codec delegate) {
        this.delegate = delegate;
    }

    @Override
    public Decoder<Object> getValueDecoder() {
        return new Decoder<Object>(){

            @Override
            public Object decode(ByteBuf buf, State state) throws IOException {
                buf.markReaderIndex();
                long[] hash = Hash.hash128(buf);
                buf.resetReaderIndex();
                Object val = ScanCodec.this.delegate.getValueDecoder().decode(buf, state);
                return new ScanObjectEntry(new HashValue(hash), val);
            }
        };
    }

    @Override
    public Encoder getValueEncoder() {
        return this.delegate.getValueEncoder();
    }

    @Override
    public Decoder<Object> getMapValueDecoder() {
        return this.delegate.getMapValueDecoder();
    }

    @Override
    public Encoder getMapValueEncoder() {
        return this.delegate.getMapValueEncoder();
    }

    @Override
    public Decoder<Object> getMapKeyDecoder() {
        return this.delegate.getMapKeyDecoder();
    }

    @Override
    public Encoder getMapKeyEncoder() {
        return this.delegate.getMapKeyEncoder();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.delegate.getClassLoader();
    }
}

