/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.redisson.client.RedisClient;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.client.protocol.decoder.ScanObjectEntry;
import org.redisson.misc.HashValue;

abstract class RedissonBaseIterator<V>
implements Iterator<V> {
    private List<HashValue> firstValues;
    private List<HashValue> lastValues;
    private Iterator<ScanObjectEntry> lastIter;
    protected long nextIterPos;
    protected RedisClient client;
    private boolean finished;
    private boolean currentElementRemoved;
    private V value;

    RedissonBaseIterator() {
    }

    @Override
    public boolean hasNext() {
        if (this.lastIter == null || !this.lastIter.hasNext()) {
            if (this.finished) {
                this.currentElementRemoved = false;
                this.client = null;
                this.firstValues = null;
                this.lastValues = null;
                this.nextIterPos = 0L;
                if (!this.tryAgain()) {
                    return false;
                }
                this.finished = false;
            }
            do {
                ListScanResult<ScanObjectEntry> res = this.iterator(this.client, this.nextIterPos);
                this.lastValues = this.convert(res.getValues());
                this.client = res.getRedisClient();
                if (this.nextIterPos == 0L && this.firstValues == null) {
                    this.firstValues = this.lastValues;
                    this.lastValues = null;
                    if (this.isEmpty(this.firstValues) && this.tryAgain()) {
                        this.client = null;
                        this.firstValues = null;
                        this.nextIterPos = 0L;
                    }
                } else if (this.isEmpty(this.firstValues)) {
                    this.firstValues = this.lastValues;
                    this.lastValues = null;
                    if (this.isEmpty(this.firstValues)) {
                        if (this.tryAgain()) {
                            this.client = null;
                            this.firstValues = null;
                            this.nextIterPos = 0L;
                            continue;
                        }
                        if (res.getPos() == 0L) {
                            this.finished = true;
                            return false;
                        }
                    }
                } else if (this.removeAll(this.lastValues, this.firstValues) || this.isEmpty(this.lastValues) && this.nextIterPos == 0L) {
                    this.currentElementRemoved = false;
                    this.client = null;
                    this.firstValues = null;
                    this.lastValues = null;
                    this.nextIterPos = 0L;
                    if (this.tryAgain()) continue;
                    this.finished = true;
                    return false;
                }
                this.lastIter = res.getValues().iterator();
                this.nextIterPos = res.getPos();
            } while (!this.lastIter.hasNext());
        }
        return this.lastIter.hasNext();
    }

    protected boolean isEmpty(List<HashValue> values) {
        return values.isEmpty();
    }

    protected boolean removeAll(List<HashValue> lastValues, List<HashValue> firstValues) {
        return lastValues.removeAll(firstValues);
    }

    protected List<HashValue> convert(List<ScanObjectEntry> list) {
        ArrayList<HashValue> result = new ArrayList<HashValue>(list.size());
        for (ScanObjectEntry entry : list) {
            result.add(entry.getHash());
        }
        return result;
    }

    protected boolean tryAgain() {
        return false;
    }

    abstract ListScanResult<ScanObjectEntry> iterator(RedisClient var1, long var2);

    @Override
    public V next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No such element");
        }
        this.value = this.lastIter.next().getObj();
        this.currentElementRemoved = false;
        return this.value;
    }

    @Override
    public void remove() {
        if (this.currentElementRemoved) {
            throw new IllegalStateException("Element been already deleted");
        }
        if (this.lastIter == null) {
            throw new IllegalStateException();
        }
        this.firstValues.remove(this.value);
        this.lastIter.remove();
        this.remove(this.value);
        this.currentElementRemoved = true;
    }

    abstract void remove(V var1);
}

