/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.action.aggregation;

import java.util.ArrayList;
import java.util.List;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.fn.Supplier;
import reactor.rx.action.Action;

public class BufferWhenAction<T>
extends Action<T, List<T>> {
    private final List<T> values = new ArrayList<T>();
    private final Supplier<? extends Publisher<?>> boundarySupplier;

    public BufferWhenAction(Supplier<? extends Publisher<?>> boundarySupplier) {
        this.boundarySupplier = boundarySupplier;
    }

    @Override
    protected void doOnSubscribe(Subscription subscription) {
        super.doOnSubscribe(subscription);
        this.boundarySupplier.get().subscribe(new Subscriber<Object>(){
            Subscription s;

            @Override
            public void onSubscribe(Subscription s) {
                this.s = s;
                s.request(1L);
            }

            @Override
            public void onNext(Object o) {
                BufferWhenAction.this.flush();
                if (this.s != null) {
                    this.s.request(1L);
                }
            }

            @Override
            public void onError(Throwable t) {
                if (this.s != null) {
                    this.s.cancel();
                }
                BufferWhenAction.this.onError(t);
            }

            @Override
            public void onComplete() {
                if (this.s != null) {
                    this.s.cancel();
                }
                BufferWhenAction.this.onComplete();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush() {
        ArrayList<T> toSend;
        List<T> list = this.values;
        synchronized (list) {
            if (this.values.isEmpty()) {
                return;
            }
            toSend = new ArrayList<T>(this.values);
            this.values.clear();
        }
        this.broadcastNext(toSend);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doError(Throwable ev) {
        List<T> list = this.values;
        synchronized (list) {
            this.values.clear();
        }
        super.doError(ev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doComplete() {
        boolean last;
        List<T> list = this.values;
        synchronized (list) {
            last = this.values.isEmpty();
        }
        if (!last) {
            this.broadcastNext(this.values);
        }
        super.doComplete();
    }

    @Override
    protected void doNext(T value) {
        this.values.add(value);
    }
}

