/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.reactivestreams;

import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Dispatcher;
import reactor.core.support.Exceptions;
import reactor.core.support.NonBlocking;
import reactor.core.support.SpecificationExceptions;

public class SubscriberBarrier<I, O>
implements Subscriber<I>,
Subscription,
NonBlocking {
    protected final Subscriber<? super O> subscriber;
    private Subscription subscription;

    public SubscriberBarrier(Subscriber<? super O> subscriber) {
        this.subscriber = subscriber;
    }

    @Override
    public final void onSubscribe(Subscription s) {
        if (s == null) {
            throw SpecificationExceptions.spec_2_13_exception();
        }
        try {
            if (this.subscription != null) {
                s.cancel();
                return;
            }
            this.subscription = s;
            this.doSubscribe(this);
        }
        catch (Throwable throwable) {
            Exceptions.throwIfFatal(throwable);
            this.doError(throwable);
        }
    }

    protected void doSubscribe(Subscription subscription) {
        this.subscriber.onSubscribe(subscription);
    }

    @Override
    public final void onNext(I i) {
        try {
            this.doNext(i);
        }
        catch (Throwable throwable) {
            this.doError(throwable);
        }
    }

    protected void doNext(I i) {
        this.subscriber.onNext(i);
    }

    @Override
    public final void onError(Throwable t) {
        this.doError(t);
    }

    protected void doError(Throwable throwable) {
        this.subscriber.onError(throwable);
    }

    @Override
    public final void onComplete() {
        try {
            this.doComplete();
        }
        catch (Throwable throwable) {
            this.doError(throwable);
        }
    }

    protected void doComplete() {
        this.subscriber.onComplete();
    }

    @Override
    public final void request(long n) {
        if (n < 0L) {
            throw SpecificationExceptions.spec_3_09_exception(n);
        }
        try {
            this.doRequest(n);
        }
        catch (Throwable throwable) {
            this.doError(throwable);
        }
    }

    protected void doRequest(long n) {
        Subscription s = this.subscription;
        if (s != null) {
            s.request(n);
        }
    }

    @Override
    public final void cancel() {
        try {
            this.doCancel();
        }
        catch (Throwable throwable) {
            this.doError(throwable);
        }
    }

    protected void doCancel() {
        Subscription s = this.subscription;
        if (s != null) {
            this.subscription = null;
            s.cancel();
        }
    }

    @Override
    public boolean isReactivePull(Dispatcher dispatcher, long producerCapacity) {
        return NonBlocking.class.isAssignableFrom(this.subscriber.getClass()) && ((NonBlocking)((Object)this.subscriber)).isReactivePull(dispatcher, producerCapacity);
    }

    @Override
    public long getCapacity() {
        return NonBlocking.class.isAssignableFrom(this.subscriber.getClass()) ? ((NonBlocking)((Object)this.subscriber)).getCapacity() : Long.MAX_VALUE;
    }
}

