/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.mapreduce;

import org.redisson.api.RLexSortedSet;
import org.redisson.api.RList;
import org.redisson.api.RObject;
import org.redisson.api.RScoredSortedSet;
import org.redisson.api.RSet;
import org.redisson.api.RSetCache;
import org.redisson.api.RSortedSet;
import org.redisson.api.mapreduce.RCollectionMapper;
import org.redisson.client.codec.Codec;
import org.redisson.mapreduce.BaseMapperTask;
import org.redisson.mapreduce.Collector;
import org.redisson.misc.Injector;

public class CollectionMapperTask<VIn, KOut, VOut>
extends BaseMapperTask<KOut, VOut> {
    private static final long serialVersionUID = -2634049426877164580L;
    RCollectionMapper<VIn, KOut, VOut> mapper;

    public CollectionMapperTask() {
    }

    public CollectionMapperTask(RCollectionMapper<VIn, KOut, VOut> mapper, Class<?> objectClass, Class<?> objectCodecClass) {
        super(objectClass, objectCodecClass);
        this.mapper = mapper;
    }

    @Override
    public void run() {
        Codec codec;
        try {
            codec = (Codec)this.objectCodecClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        Injector.inject(this.mapper, this.redisson);
        for (String objectName : this.objectNames) {
            RObject collection = null;
            if (RSetCache.class.isAssignableFrom(this.objectClass)) {
                collection = this.redisson.getSetCache(objectName, codec);
            } else if (RSet.class.isAssignableFrom(this.objectClass)) {
                collection = this.redisson.getSet(objectName, codec);
            } else if (RSortedSet.class.isAssignableFrom(this.objectClass)) {
                collection = this.redisson.getSortedSet(objectName, codec);
            } else if (RScoredSortedSet.class.isAssignableFrom(this.objectClass)) {
                collection = this.redisson.getScoredSortedSet(objectName, codec);
            } else if (RLexSortedSet.class.isAssignableFrom(this.objectClass)) {
                collection = this.redisson.getLexSortedSet(objectName);
            } else if (RList.class.isAssignableFrom(this.objectClass)) {
                collection = this.redisson.getList(objectName, codec);
            } else {
                throw new IllegalStateException("Unable to work with " + this.objectClass);
            }
            Collector collector = new Collector(codec, this.redisson, this.collectorMapName, this.workersAmount, this.timeout);
            for (Object value : collection) {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                this.mapper.map(value, collector);
            }
        }
    }
}

