/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection.balancer;

import io.netty.util.concurrent.Future;
import io.netty.util.internal.PlatformDependent;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Map;
import org.redisson.api.NodeType;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisConnectionException;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.ReadMode;
import org.redisson.connection.ClientConnectionsEntry;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.CountableListener;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.connection.pool.PubSubConnectionPool;
import org.redisson.connection.pool.SlaveConnectionPool;
import org.redisson.misc.RedissonPromise;
import org.redisson.misc.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBalancerManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ConnectionManager connectionManager;
    private final PubSubConnectionPool pubSubConnectionPool;
    private final SlaveConnectionPool slaveConnectionPool;
    private final Map<RedisClient, ClientConnectionsEntry> client2Entry = PlatformDependent.newConcurrentHashMap();

    public LoadBalancerManager(MasterSlaveServersConfig config, ConnectionManager connectionManager, MasterSlaveEntry entry) {
        this.connectionManager = connectionManager;
        this.slaveConnectionPool = new SlaveConnectionPool(config, connectionManager, entry);
        this.pubSubConnectionPool = new PubSubConnectionPool(config, connectionManager, entry);
    }

    public void changeType(RedisClient redisClient, NodeType nodeType) {
        ClientConnectionsEntry entry = this.getEntry(redisClient);
        this.changeType(nodeType, entry);
    }

    protected void changeType(NodeType nodeType, ClientConnectionsEntry entry) {
        if (entry != null) {
            if (this.connectionManager.isClusterMode()) {
                entry.getClient().getConfig().setReadOnly(nodeType == NodeType.SLAVE && this.connectionManager.getConfig().getReadMode() != ReadMode.MASTER);
            }
            entry.setNodeType(nodeType);
        }
    }

    public void changeType(URI address, NodeType nodeType) {
        ClientConnectionsEntry entry = this.getEntry(address);
        this.changeType(nodeType, entry);
    }

    public RFuture<Void> add(final ClientConnectionsEntry entry) {
        RedissonPromise<Void> result = new RedissonPromise<Void>();
        CountableListener<Void> listener = new CountableListener<Void>(result, null){

            @Override
            public void operationComplete(Future<Object> future) throws Exception {
                super.operationComplete(future);
                if (this.result.isSuccess()) {
                    LoadBalancerManager.this.client2Entry.put(entry.getClient(), entry);
                }
            }
        };
        RFuture slaveFuture = this.slaveConnectionPool.add(entry);
        listener.incCounter();
        slaveFuture.addListener(listener);
        RFuture pubSubFuture = this.pubSubConnectionPool.add(entry);
        listener.incCounter();
        pubSubFuture.addListener(listener);
        return result;
    }

    public int getAvailableClients() {
        int count = 0;
        for (ClientConnectionsEntry connectionEntry : this.client2Entry.values()) {
            if (connectionEntry.isFreezed()) continue;
            ++count;
        }
        return count;
    }

    public boolean unfreeze(URI address, ClientConnectionsEntry.FreezeReason freezeReason) {
        ClientConnectionsEntry entry = this.getEntry(address);
        if (entry == null) {
            throw new IllegalStateException("Can't find " + address + " in slaves!");
        }
        return this.unfreeze(entry, freezeReason);
    }

    public boolean unfreeze(InetSocketAddress address, ClientConnectionsEntry.FreezeReason freezeReason) {
        ClientConnectionsEntry entry = this.getEntry(address);
        if (entry == null) {
            throw new IllegalStateException("Can't find " + address + " in slaves!");
        }
        return this.unfreeze(entry, freezeReason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unfreeze(ClientConnectionsEntry entry, ClientConnectionsEntry.FreezeReason freezeReason) {
        ClientConnectionsEntry clientConnectionsEntry = entry;
        synchronized (clientConnectionsEntry) {
            if (!entry.isFreezed()) {
                return false;
            }
            if (freezeReason == ClientConnectionsEntry.FreezeReason.RECONNECT && entry.getFreezeReason() == ClientConnectionsEntry.FreezeReason.RECONNECT || freezeReason != ClientConnectionsEntry.FreezeReason.RECONNECT) {
                entry.resetFailedAttempts();
                entry.setFreezed(false);
                entry.setFreezeReason(null);
                return true;
            }
        }
        return false;
    }

    public ClientConnectionsEntry freeze(URI address, ClientConnectionsEntry.FreezeReason freezeReason) {
        ClientConnectionsEntry connectionEntry = this.getEntry(address);
        return this.freeze(connectionEntry, freezeReason);
    }

    public ClientConnectionsEntry freeze(InetSocketAddress address, ClientConnectionsEntry.FreezeReason freezeReason) {
        ClientConnectionsEntry connectionEntry = this.getEntry(address);
        return this.freeze(connectionEntry, freezeReason);
    }

    public ClientConnectionsEntry freeze(RedisClient redisClient, ClientConnectionsEntry.FreezeReason freezeReason) {
        ClientConnectionsEntry connectionEntry = this.getEntry(redisClient);
        return this.freeze(connectionEntry, freezeReason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientConnectionsEntry freeze(ClientConnectionsEntry connectionEntry, ClientConnectionsEntry.FreezeReason freezeReason) {
        if (connectionEntry == null) {
            return null;
        }
        ClientConnectionsEntry clientConnectionsEntry = connectionEntry;
        synchronized (clientConnectionsEntry) {
            if (connectionEntry.getFreezeReason() == null || connectionEntry.getFreezeReason() == ClientConnectionsEntry.FreezeReason.RECONNECT) {
                connectionEntry.setFreezed(true);
                connectionEntry.setFreezeReason(freezeReason);
                return connectionEntry;
            }
            if (connectionEntry.isFreezed()) {
                return null;
            }
        }
        return connectionEntry;
    }

    public RFuture<RedisPubSubConnection> nextPubSubConnection() {
        return this.pubSubConnectionPool.get();
    }

    public boolean contains(InetSocketAddress addr) {
        return this.getEntry(addr) != null;
    }

    public boolean contains(URI addr) {
        return this.getEntry(addr) != null;
    }

    public boolean contains(RedisClient redisClient) {
        return this.getEntry(redisClient) != null;
    }

    protected ClientConnectionsEntry getEntry(URI addr) {
        for (ClientConnectionsEntry entry : this.client2Entry.values()) {
            InetSocketAddress entryAddr = entry.getClient().getAddr();
            if (!URIBuilder.compare(entryAddr, addr)) continue;
            return entry;
        }
        return null;
    }

    protected ClientConnectionsEntry getEntry(InetSocketAddress address) {
        for (ClientConnectionsEntry entry : this.client2Entry.values()) {
            InetSocketAddress addr = entry.getClient().getAddr();
            if (!addr.getAddress().equals(address.getAddress()) || addr.getPort() != address.getPort()) continue;
            return entry;
        }
        return null;
    }

    protected ClientConnectionsEntry getEntry(RedisClient redisClient) {
        return this.client2Entry.get(redisClient);
    }

    protected String convert(InetSocketAddress addr) {
        return addr.getAddress().getHostAddress() + ":" + addr.getPort();
    }

    public RFuture<RedisConnection> getConnection(RedisCommand<?> command, URI addr) {
        ClientConnectionsEntry entry = this.getEntry(addr);
        if (entry != null) {
            return this.slaveConnectionPool.get((RedisCommand)command, entry);
        }
        RedisConnectionException exception = new RedisConnectionException("Can't find entry for " + addr);
        return this.connectionManager.newFailedFuture(exception);
    }

    public RFuture<RedisConnection> nextConnection(RedisCommand<?> command) {
        return this.slaveConnectionPool.get((RedisCommand)command);
    }

    public void returnPubSubConnection(RedisPubSubConnection connection) {
        ClientConnectionsEntry entry = this.getEntry(connection.getRedisClient());
        this.pubSubConnectionPool.returnConnection(entry, connection);
    }

    public void returnConnection(RedisConnection connection) {
        ClientConnectionsEntry entry = this.getEntry(connection.getRedisClient());
        this.slaveConnectionPool.returnConnection(entry, connection);
    }

    public void shutdown() {
        for (ClientConnectionsEntry entry : this.client2Entry.values()) {
            entry.getClient().shutdown();
        }
    }

    public void shutdownAsync() {
        for (ClientConnectionsEntry entry : this.client2Entry.values()) {
            this.connectionManager.shutdownAsync(entry.getClient());
        }
    }
}

