/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.command;

import java.util.Collection;
import java.util.List;
import org.reactivestreams.Publisher;
import org.redisson.SlotCallback;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.command.CommandAsyncService;
import org.redisson.command.CommandReactiveExecutor;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.reactive.NettyFuturePublisher;
import reactor.fn.Supplier;

public class CommandReactiveService
extends CommandAsyncService
implements CommandReactiveExecutor {
    public CommandReactiveService(ConnectionManager connectionManager) {
        super(connectionManager);
    }

    @Override
    public <T, R> Publisher<R> evalWriteAllReactive(final RedisCommand<T> command, final SlotCallback<T, R> callback, final String script, final List<Object> keys, final Object ... params) {
        return this.reactive(new Supplier<RFuture<R>>(){

            @Override
            public RFuture<R> get() {
                return CommandReactiveService.this.evalWriteAllAsync(command, callback, script, keys, params);
            }
        });
    }

    @Override
    public <R> Publisher<R> reactive(Supplier<RFuture<R>> supplier) {
        return new NettyFuturePublisher(supplier);
    }

    @Override
    public <T, R> Publisher<Collection<R>> readAllReactive(final RedisCommand<T> command, final Object ... params) {
        return this.reactive(new Supplier<RFuture<Collection<R>>>(){

            @Override
            public RFuture<Collection<R>> get() {
                return CommandReactiveService.this.readAllAsync(command, params);
            }
        });
    }

    @Override
    public <T, R> Publisher<R> readRandomReactive(final RedisCommand<T> command, final Object ... params) {
        return this.reactive(new Supplier<RFuture<R>>(){

            @Override
            public RFuture<R> get() {
                return CommandReactiveService.this.readRandomAsync(command, params);
            }
        });
    }

    @Override
    public <T, R> Publisher<R> readReactive(final RedisClient client, final String name, final Codec codec, final RedisCommand<T> command, final Object ... params) {
        return this.reactive(new Supplier<RFuture<R>>(){

            @Override
            public RFuture<R> get() {
                return CommandReactiveService.this.readAsync(client, name, codec, command, params);
            }
        });
    }

    @Override
    public <T, R> Publisher<R> writeReactive(String key, RedisCommand<T> command, Object ... params) {
        return this.writeReactive(key, this.connectionManager.getCodec(), command, params);
    }

    @Override
    public <T, R> Publisher<R> writeReactive(final String key, final Codec codec, final RedisCommand<T> command, final Object ... params) {
        return this.reactive(new Supplier<RFuture<R>>(){

            @Override
            public RFuture<R> get() {
                return CommandReactiveService.this.writeAsync(key, codec, command, params);
            }
        });
    }

    @Override
    public <T, R> Publisher<R> writeReactive(final MasterSlaveEntry entry, final Codec codec, final RedisCommand<T> command, final Object ... params) {
        return this.reactive(new Supplier<RFuture<R>>(){

            @Override
            public RFuture<R> get() {
                return CommandReactiveService.this.writeAsync(entry, codec, command, params);
            }
        });
    }

    @Override
    public <T, R> Publisher<R> readReactive(String key, RedisCommand<T> command, Object ... params) {
        return this.readReactive(key, this.connectionManager.getCodec(), command, params);
    }

    @Override
    public <T, R> Publisher<R> readReactive(final String key, final Codec codec, final RedisCommand<T> command, final Object ... params) {
        return this.reactive(new Supplier<RFuture<R>>(){

            @Override
            public RFuture<R> get() {
                return CommandReactiveService.this.readAsync(key, codec, command, params);
            }
        });
    }

    @Override
    public <T, R> Publisher<R> evalReadReactive(final String key, final Codec codec, final RedisCommand<T> evalCommandType, final String script, final List<Object> keys, final Object ... params) {
        return this.reactive(new Supplier<RFuture<R>>(){

            @Override
            public RFuture<R> get() {
                return CommandReactiveService.this.evalReadAsync(key, codec, evalCommandType, script, (List<Object>)keys, params);
            }
        });
    }

    @Override
    public <T, R> Publisher<R> evalWriteReactive(final String key, final Codec codec, final RedisCommand<T> evalCommandType, final String script, final List<Object> keys, final Object ... params) {
        return this.reactive(new Supplier<RFuture<R>>(){

            @Override
            public RFuture<R> get() {
                return CommandReactiveService.this.evalWriteAsync(key, codec, evalCommandType, script, (List<Object>)keys, params);
            }
        });
    }

    @Override
    public <T> Publisher<Void> writeAllReactive(final RedisCommand<T> command, final Object ... params) {
        return this.reactive(new Supplier<RFuture<Void>>(){

            @Override
            public RFuture<Void> get() {
                return CommandReactiveService.this.writeAllAsync(command, params);
            }
        });
    }

    @Override
    public <R, T> Publisher<R> writeAllReactive(final RedisCommand<T> command, final SlotCallback<T, R> callback, final Object ... params) {
        return this.reactive(new Supplier<RFuture<R>>(){

            @Override
            public RFuture<R> get() {
                return CommandReactiveService.this.writeAllAsync(command, callback, params);
            }
        });
    }
}

