/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.loading;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ReflectPermission;
import java.lang.reflect.Type;
import java.net.URL;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.dynamic.loading.PackageDefinitionStrategy;
import net.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import net.bytebuddy.implementation.FixedValue;
import net.bytebuddy.implementation.MethodCall;
import net.bytebuddy.utility.JavaType;
import net.bytebuddy.utility.RandomString;

public interface ClassInjector {
    public static final boolean ALLOW_EXISTING_TYPES = false;

    public Map<TypeDescription, Class<?>> inject(Map<? extends TypeDescription, byte[]> var1);

    public static class UsingInstrumentation
    implements ClassInjector {
        private static final String PREFIX = "jar";
        private static final String CLASS_FILE_EXTENSION = ".class";
        private final Instrumentation instrumentation;
        private final Target target;
        private final File folder;
        private final RandomString randomString;

        public static ClassInjector of(File folder, Target target, Instrumentation instrumentation) {
            return new UsingInstrumentation(folder, target, instrumentation, new RandomString());
        }

        protected UsingInstrumentation(File folder, Target target, Instrumentation instrumentation, RandomString randomString) {
            this.folder = folder;
            this.target = target;
            this.instrumentation = instrumentation;
            this.randomString = randomString;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<TypeDescription, Class<?>> inject(Map<? extends TypeDescription, byte[]> types) {
            File jarFile = new File(this.folder, String.format("%s%s.jar", PREFIX, this.randomString.nextString()));
            try {
                if (!jarFile.createNewFile()) {
                    throw new IllegalStateException("Cannot create file " + jarFile);
                }
                JarOutputStream jarOutputStream = new JarOutputStream(new FileOutputStream(jarFile));
                try {
                    for (Map.Entry<? extends TypeDescription, byte[]> entry : types.entrySet()) {
                        jarOutputStream.putNextEntry(new JarEntry(entry.getKey().getInternalName() + CLASS_FILE_EXTENSION));
                        jarOutputStream.write(entry.getValue());
                    }
                }
                finally {
                    jarOutputStream.close();
                }
                this.target.inject(this.instrumentation, new JarFile(jarFile));
                HashMap loaded = new HashMap();
                for (TypeDescription typeDescription : types.keySet()) {
                    loaded.put(typeDescription, Class.forName(typeDescription.getName(), false, ClassLoader.getSystemClassLoader()));
                }
                return loaded;
            }
            catch (IOException exception) {
                throw new IllegalStateException("Cannot write jar file to disk", exception);
            }
            catch (ClassNotFoundException exception) {
                throw new IllegalStateException("Cannot load injected class", exception);
            }
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UsingInstrumentation)) {
                return false;
            }
            UsingInstrumentation other = (UsingInstrumentation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Instrumentation this$instrumentation = this.instrumentation;
            Instrumentation other$instrumentation = other.instrumentation;
            if (this$instrumentation == null ? other$instrumentation != null : !this$instrumentation.equals(other$instrumentation)) {
                return false;
            }
            Target this$target = this.target;
            Target other$target = other.target;
            if (this$target == null ? other$target != null : !((Object)((Object)this$target)).equals((Object)other$target)) {
                return false;
            }
            File this$folder = this.folder;
            File other$folder = other.folder;
            if (this$folder == null ? other$folder != null : !((Object)this$folder).equals(other$folder)) {
                return false;
            }
            RandomString this$randomString = this.randomString;
            RandomString other$randomString = other.randomString;
            return !(this$randomString == null ? other$randomString != null : !this$randomString.equals(other$randomString));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UsingInstrumentation;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Instrumentation $instrumentation = this.instrumentation;
            result = result * 59 + ($instrumentation == null ? 43 : $instrumentation.hashCode());
            Target $target = this.target;
            result = result * 59 + ($target == null ? 43 : ((Object)((Object)$target)).hashCode());
            File $folder = this.folder;
            result = result * 59 + ($folder == null ? 43 : ((Object)$folder).hashCode());
            RandomString $randomString = this.randomString;
            result = result * 59 + ($randomString == null ? 43 : $randomString.hashCode());
            return result;
        }

        public static enum Target {
            BOOTSTRAP{

                @Override
                protected void inject(Instrumentation instrumentation, JarFile jarFile) {
                    instrumentation.appendToBootstrapClassLoaderSearch(jarFile);
                }
            }
            ,
            SYSTEM{

                @Override
                protected void inject(Instrumentation instrumentation, JarFile jarFile) {
                    instrumentation.appendToSystemClassLoaderSearch(jarFile);
                }
            };


            protected abstract void inject(Instrumentation var1, JarFile var2);
        }
    }

    public static class UsingUnsafe
    implements ClassInjector {
        private static final Dispatcher.Initializable DISPATCHER = AccessController.doPrivileged(Dispatcher.CreationAction.INSTANCE);
        private static final Object BOOTSTRAP_LOADER_LOCK = new Object();
        private final ClassLoader classLoader;
        private final ProtectionDomain protectionDomain;

        public UsingUnsafe(ClassLoader classLoader) {
            this(classLoader, ClassLoadingStrategy.NO_PROTECTION_DOMAIN);
        }

        public UsingUnsafe(ClassLoader classLoader, ProtectionDomain protectionDomain) {
            this.classLoader = classLoader;
            this.protectionDomain = protectionDomain;
        }

        public static boolean isAvailable() {
            return DISPATCHER.isAvailable();
        }

        public static ClassInjector ofBootstrapLoader() {
            return new UsingUnsafe(ClassLoadingStrategy.BOOTSTRAP_LOADER);
        }

        public static ClassInjector ofClassPath() {
            return new UsingUnsafe(ClassLoader.getSystemClassLoader());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<TypeDescription, Class<?>> inject(Map<? extends TypeDescription, byte[]> types) {
            Dispatcher dispatcher = DISPATCHER.initialize();
            HashMap loaded = new HashMap();
            Object object = this.classLoader == null ? BOOTSTRAP_LOADER_LOCK : this.classLoader;
            synchronized (object) {
                for (Map.Entry<? extends TypeDescription, byte[]> entry : types.entrySet()) {
                    try {
                        loaded.put(entry.getKey(), Class.forName(entry.getKey().getName(), false, this.classLoader));
                    }
                    catch (ClassNotFoundException ignored) {
                        loaded.put(entry.getKey(), dispatcher.defineClass(this.classLoader, entry.getKey().getName(), entry.getValue(), this.protectionDomain));
                    }
                }
            }
            return loaded;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UsingUnsafe)) {
                return false;
            }
            UsingUnsafe other = (UsingUnsafe)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ClassLoader this$classLoader = this.classLoader;
            ClassLoader other$classLoader = other.classLoader;
            if (this$classLoader == null ? other$classLoader != null : !this$classLoader.equals(other$classLoader)) {
                return false;
            }
            ProtectionDomain this$protectionDomain = this.protectionDomain;
            ProtectionDomain other$protectionDomain = other.protectionDomain;
            return !(this$protectionDomain == null ? other$protectionDomain != null : !this$protectionDomain.equals(other$protectionDomain));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UsingUnsafe;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ClassLoader $classLoader = this.classLoader;
            result = result * 59 + ($classLoader == null ? 43 : $classLoader.hashCode());
            ProtectionDomain $protectionDomain = this.protectionDomain;
            result = result * 59 + ($protectionDomain == null ? 43 : $protectionDomain.hashCode());
            return result;
        }

        static interface Dispatcher {
            public Class<?> defineClass(ClassLoader var1, String var2, byte[] var3, ProtectionDomain var4);

            public static class Disabled
            implements Initializable {
                private final Exception exception;

                protected Disabled(Exception exception) {
                    this.exception = exception;
                }

                @Override
                public boolean isAvailable() {
                    return false;
                }

                @Override
                public Dispatcher initialize() {
                    throw new IllegalStateException("Could not find sun.misc.Unsafe", this.exception);
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Disabled)) {
                        return false;
                    }
                    Disabled other = (Disabled)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Exception this$exception = this.exception;
                    Exception other$exception = other.exception;
                    return !(this$exception == null ? other$exception != null : !this$exception.equals(other$exception));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof Disabled;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Exception $exception = this.exception;
                    result = result * 59 + ($exception == null ? 43 : $exception.hashCode());
                    return result;
                }
            }

            public static class Enabled
            implements Dispatcher,
            Initializable {
                private final Field theUnsafe;
                private final Method defineClass;

                protected Enabled(Field theUnsafe, Method defineClass) {
                    this.theUnsafe = theUnsafe;
                    this.defineClass = defineClass;
                }

                @Override
                public boolean isAvailable() {
                    return true;
                }

                @Override
                @SuppressFBWarnings(value={"DP_DO_INSIDE_DO_PRIVILEGED"}, justification="Privilege is explicit caller responsibility")
                public Dispatcher initialize() {
                    this.theUnsafe.setAccessible(true);
                    return this;
                }

                @Override
                public Class<?> defineClass(ClassLoader classLoader, String name, byte[] binaryRepresentation, ProtectionDomain protectionDomain) {
                    try {
                        return (Class)this.defineClass.invoke(this.theUnsafe.get(null), name, binaryRepresentation, 0, binaryRepresentation.length, classLoader, protectionDomain);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Could not access Unsafe::defineClass", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking Unsafe::defineClass", exception.getCause());
                    }
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Enabled)) {
                        return false;
                    }
                    Enabled other = (Enabled)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Field this$theUnsafe = this.theUnsafe;
                    Field other$theUnsafe = other.theUnsafe;
                    if (this$theUnsafe == null ? other$theUnsafe != null : !((Object)this$theUnsafe).equals(other$theUnsafe)) {
                        return false;
                    }
                    Method this$defineClass = this.defineClass;
                    Method other$defineClass = other.defineClass;
                    return !(this$defineClass == null ? other$defineClass != null : !((Object)this$defineClass).equals(other$defineClass));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof Enabled;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Field $theUnsafe = this.theUnsafe;
                    result = result * 59 + ($theUnsafe == null ? 43 : ((Object)$theUnsafe).hashCode());
                    Method $defineClass = this.defineClass;
                    result = result * 59 + ($defineClass == null ? 43 : ((Object)$defineClass).hashCode());
                    return result;
                }
            }

            public static enum CreationAction implements PrivilegedAction<Initializable>
            {
                INSTANCE;


                @Override
                @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should not be rethrown but trigger a fallback")
                public Initializable run() {
                    try {
                        Class<?> unsafe = Class.forName("sun.misc.Unsafe");
                        return new Enabled(unsafe.getDeclaredField("theUnsafe"), unsafe.getMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ClassLoader.class, ProtectionDomain.class));
                    }
                    catch (Exception exception) {
                        return new Disabled(exception);
                    }
                }
            }

            public static interface Initializable {
                public boolean isAvailable();

                public Dispatcher initialize();
            }
        }
    }

    public static class UsingLookup
    implements ClassInjector {
        private static final Dispatcher DISPATCHER = AccessController.doPrivileged(Dispatcher.Creator.INSTANCE);
        private static final int PACKAGE_LOOKUP = 8;
        private final Object lookup;

        protected UsingLookup(Object lookup) {
            this.lookup = lookup;
        }

        public static UsingLookup of(Object lookup) {
            if (!DISPATCHER.isAlive()) {
                throw new IllegalStateException("The current VM does not support class definition via method handle lookups");
            }
            if (!JavaType.METHOD_HANDLES_LOOKUP.getTypeStub().isInstance(lookup)) {
                throw new IllegalArgumentException("Not a method handle lookup: " + lookup);
            }
            if ((DISPATCHER.lookupModes(lookup) & 8) == 0) {
                throw new IllegalArgumentException("Lookup does not imply package-access: " + lookup);
            }
            return new UsingLookup(DISPATCHER.dropLookupMode(lookup, 2));
        }

        public Class<?> lookupType() {
            return DISPATCHER.lookupType(this.lookup);
        }

        @Override
        public Map<TypeDescription, Class<?>> inject(Map<? extends TypeDescription, byte[]> types) {
            HashMap loaded = new HashMap();
            for (Map.Entry<? extends TypeDescription, byte[]> entry : types.entrySet()) {
                if (!entry.getKey().isSamePackage(new TypeDescription.ForLoadedType(this.lookupType()))) {
                    throw new IllegalArgumentException(entry.getKey() + " cannot be defined in its package using " + this.lookup);
                }
                loaded.put(entry.getKey(), DISPATCHER.defineClass(this.lookup, entry.getValue()));
            }
            return loaded;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UsingLookup)) {
                return false;
            }
            UsingLookup other = (UsingLookup)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Object this$lookup = this.lookup;
            Object other$lookup = other.lookup;
            return !(this$lookup == null ? other$lookup != null : !this$lookup.equals(other$lookup));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UsingLookup;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Object $lookup = this.lookup;
            result = result * 59 + ($lookup == null ? 43 : $lookup.hashCode());
            return result;
        }

        protected static interface Dispatcher {
            public boolean isAlive();

            public Class<?> lookupType(Object var1);

            public int lookupModes(Object var1);

            public Object dropLookupMode(Object var1, int var2);

            public Class<?> defineClass(Object var1, byte[] var2);

            public static class ForJava9CapableVm
            implements Dispatcher {
                private final Method lookupClass;
                private final Method lookupModes;
                private final Method dropLookupMode;
                private final Method defineClass;

                protected ForJava9CapableVm(Method lookupClass, Method lookupModes, Method dropLookupMode, Method defineClass) {
                    this.lookupClass = lookupClass;
                    this.lookupModes = lookupModes;
                    this.defineClass = defineClass;
                    this.dropLookupMode = dropLookupMode;
                }

                @Override
                public boolean isAlive() {
                    return true;
                }

                @Override
                public Class<?> lookupType(Object lookup) {
                    try {
                        return (Class)this.lookupClass.invoke(lookup, new Object[0]);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.invoke.MethodHandles$Lookup#lookupClass", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.invoke.MethodHandles$Lookup#lookupClass", exception.getCause());
                    }
                }

                @Override
                public int lookupModes(Object lookup) {
                    try {
                        return (Integer)this.lookupModes.invoke(lookup, new Object[0]);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.invoke.MethodHandles$Lookup#lookupModes", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.invoke.MethodHandles$Lookup#lookupModes", exception.getCause());
                    }
                }

                @Override
                public Object dropLookupMode(Object lookup, int mode) {
                    try {
                        return this.dropLookupMode.invoke(lookup, mode);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.invoke.MethodHandles$Lookup#lookupModes", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.invoke.MethodHandles$Lookup#lookupModes", exception.getCause());
                    }
                }

                @Override
                public Class<?> defineClass(Object lookup, byte[] binaryRepresentation) {
                    try {
                        return (Class)this.defineClass.invoke(lookup, new Object[]{binaryRepresentation});
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.invoke.MethodHandles$Lookup#defineClass", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.invoke.MethodHandles$Lookup#defineClass", exception.getCause());
                    }
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ForJava9CapableVm)) {
                        return false;
                    }
                    ForJava9CapableVm other = (ForJava9CapableVm)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Method this$lookupClass = this.lookupClass;
                    Method other$lookupClass = other.lookupClass;
                    if (this$lookupClass == null ? other$lookupClass != null : !((Object)this$lookupClass).equals(other$lookupClass)) {
                        return false;
                    }
                    Method this$lookupModes = this.lookupModes;
                    Method other$lookupModes = other.lookupModes;
                    if (this$lookupModes == null ? other$lookupModes != null : !((Object)this$lookupModes).equals(other$lookupModes)) {
                        return false;
                    }
                    Method this$dropLookupMode = this.dropLookupMode;
                    Method other$dropLookupMode = other.dropLookupMode;
                    if (this$dropLookupMode == null ? other$dropLookupMode != null : !((Object)this$dropLookupMode).equals(other$dropLookupMode)) {
                        return false;
                    }
                    Method this$defineClass = this.defineClass;
                    Method other$defineClass = other.defineClass;
                    return !(this$defineClass == null ? other$defineClass != null : !((Object)this$defineClass).equals(other$defineClass));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof ForJava9CapableVm;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Method $lookupClass = this.lookupClass;
                    result = result * 59 + ($lookupClass == null ? 43 : ((Object)$lookupClass).hashCode());
                    Method $lookupModes = this.lookupModes;
                    result = result * 59 + ($lookupModes == null ? 43 : ((Object)$lookupModes).hashCode());
                    Method $dropLookupMode = this.dropLookupMode;
                    result = result * 59 + ($dropLookupMode == null ? 43 : ((Object)$dropLookupMode).hashCode());
                    Method $defineClass = this.defineClass;
                    result = result * 59 + ($defineClass == null ? 43 : ((Object)$defineClass).hashCode());
                    return result;
                }
            }

            public static enum ForLegacyVm implements Dispatcher
            {
                INSTANCE;


                @Override
                public boolean isAlive() {
                    return false;
                }

                @Override
                public Class<?> lookupType(Object lookup) {
                    throw new IllegalStateException("Cannot dispatch method for java.lang.invoke.MethodHandles$Lookup");
                }

                @Override
                public int lookupModes(Object lookup) {
                    throw new IllegalStateException("Cannot dispatch method for java.lang.invoke.MethodHandles$Lookup");
                }

                @Override
                public Object dropLookupMode(Object lookup, int mode) {
                    throw new IllegalStateException("Cannot dispatch method for java.lang.invoke.MethodHandles$Lookup");
                }

                @Override
                public Class<?> defineClass(Object lookup, byte[] binaryRepresentation) {
                    throw new IllegalStateException("Cannot dispatch method for java.lang.invoke.MethodHandles$Lookup");
                }
            }

            public static enum Creator implements PrivilegedAction<Dispatcher>
            {
                INSTANCE;


                @Override
                @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should not be rethrown but trigger a fallback")
                public Dispatcher run() {
                    try {
                        Class<?> lookup = JavaType.METHOD_HANDLES_LOOKUP.load();
                        return new ForJava9CapableVm(lookup.getMethod("lookupClass", new Class[0]), lookup.getMethod("lookupModes", new Class[0]), lookup.getMethod("dropLookupMode", Integer.TYPE), lookup.getMethod("defineClass", byte[].class));
                    }
                    catch (Exception ignored) {
                        return ForLegacyVm.INSTANCE;
                    }
                }
            }
        }
    }

    public static class UsingReflection
    implements ClassInjector {
        private static final Dispatcher.Initializable DISPATCHER = AccessController.doPrivileged(Dispatcher.CreationAction.INSTANCE);
        private final ClassLoader classLoader;
        private final ProtectionDomain protectionDomain;
        private final PackageDefinitionStrategy packageDefinitionStrategy;
        private final boolean forbidExisting;

        public UsingReflection(ClassLoader classLoader) {
            this(classLoader, ClassLoadingStrategy.NO_PROTECTION_DOMAIN);
        }

        public UsingReflection(ClassLoader classLoader, ProtectionDomain protectionDomain) {
            this(classLoader, protectionDomain, PackageDefinitionStrategy.Trivial.INSTANCE, false);
        }

        public UsingReflection(ClassLoader classLoader, ProtectionDomain protectionDomain, PackageDefinitionStrategy packageDefinitionStrategy, boolean forbidExisting) {
            if (classLoader == null) {
                throw new IllegalArgumentException("Cannot inject classes into the bootstrap class loader");
            }
            this.classLoader = classLoader;
            this.protectionDomain = protectionDomain;
            this.packageDefinitionStrategy = packageDefinitionStrategy;
            this.forbidExisting = forbidExisting;
        }

        public static boolean isAvailable() {
            return DISPATCHER.isAvailable();
        }

        public static ClassInjector ofSystemClassLoader() {
            return new UsingReflection(ClassLoader.getSystemClassLoader());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<TypeDescription, Class<?>> inject(Map<? extends TypeDescription, byte[]> types) {
            Dispatcher dispatcher = DISPATCHER.initialize();
            HashMap loadedTypes = new HashMap();
            for (Map.Entry<? extends TypeDescription, byte[]> entry : types.entrySet()) {
                String typeName = entry.getKey().getName();
                Object object = dispatcher.getClassLoadingLock(this.classLoader, typeName);
                synchronized (object) {
                    Class<?> type = dispatcher.findClass(this.classLoader, typeName);
                    if (type == null) {
                        String packageName;
                        PackageDefinitionStrategy.Definition definition;
                        int packageIndex = typeName.lastIndexOf(46);
                        if (packageIndex != -1 && (definition = this.packageDefinitionStrategy.define(this.classLoader, packageName = typeName.substring(0, packageIndex), typeName)).isDefined()) {
                            Package definedPackage = dispatcher.getPackage(this.classLoader, packageName);
                            if (definedPackage == null) {
                                dispatcher.definePackage(this.classLoader, packageName, definition.getSpecificationTitle(), definition.getSpecificationVersion(), definition.getSpecificationVendor(), definition.getImplementationTitle(), definition.getImplementationVersion(), definition.getImplementationVendor(), definition.getSealBase());
                            } else if (!definition.isCompatibleTo(definedPackage)) {
                                throw new SecurityException("Sealing violation for package " + packageName);
                            }
                        }
                        type = dispatcher.defineClass(this.classLoader, typeName, entry.getValue(), this.protectionDomain);
                    } else if (this.forbidExisting) {
                        throw new IllegalStateException("Cannot inject already loaded type: " + type);
                    }
                    loadedTypes.put(entry.getKey(), type);
                }
            }
            return loadedTypes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UsingReflection)) {
                return false;
            }
            UsingReflection other = (UsingReflection)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ClassLoader this$classLoader = this.classLoader;
            ClassLoader other$classLoader = other.classLoader;
            if (this$classLoader == null ? other$classLoader != null : !this$classLoader.equals(other$classLoader)) {
                return false;
            }
            ProtectionDomain this$protectionDomain = this.protectionDomain;
            ProtectionDomain other$protectionDomain = other.protectionDomain;
            if (this$protectionDomain == null ? other$protectionDomain != null : !this$protectionDomain.equals(other$protectionDomain)) {
                return false;
            }
            PackageDefinitionStrategy this$packageDefinitionStrategy = this.packageDefinitionStrategy;
            PackageDefinitionStrategy other$packageDefinitionStrategy = other.packageDefinitionStrategy;
            if (this$packageDefinitionStrategy == null ? other$packageDefinitionStrategy != null : !this$packageDefinitionStrategy.equals(other$packageDefinitionStrategy)) {
                return false;
            }
            return this.forbidExisting == other.forbidExisting;
        }

        protected boolean canEqual(Object other) {
            return other instanceof UsingReflection;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ClassLoader $classLoader = this.classLoader;
            result = result * 59 + ($classLoader == null ? 43 : $classLoader.hashCode());
            ProtectionDomain $protectionDomain = this.protectionDomain;
            result = result * 59 + ($protectionDomain == null ? 43 : $protectionDomain.hashCode());
            PackageDefinitionStrategy $packageDefinitionStrategy = this.packageDefinitionStrategy;
            result = result * 59 + ($packageDefinitionStrategy == null ? 43 : $packageDefinitionStrategy.hashCode());
            result = result * 59 + (this.forbidExisting ? 79 : 97);
            return result;
        }

        protected static interface Dispatcher {
            public static final Class<?> UNDEFINED = null;

            public Object getClassLoadingLock(ClassLoader var1, String var2);

            public Class<?> findClass(ClassLoader var1, String var2);

            public Class<?> defineClass(ClassLoader var1, String var2, byte[] var3, ProtectionDomain var4);

            public Package getPackage(ClassLoader var1, String var2);

            public Package definePackage(ClassLoader var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, URL var9);

            public static class Unavailable
            implements Dispatcher,
            Initializable {
                private final Exception exception;

                protected Unavailable(Exception exception) {
                    this.exception = exception;
                }

                @Override
                public boolean isAvailable() {
                    return false;
                }

                @Override
                public Dispatcher initialize() {
                    return this;
                }

                @Override
                public Object getClassLoadingLock(ClassLoader classLoader, String name) {
                    return classLoader;
                }

                @Override
                public Class<?> findClass(ClassLoader classLoader, String name) {
                    try {
                        return classLoader.loadClass(name);
                    }
                    catch (ClassNotFoundException ignored) {
                        return UNDEFINED;
                    }
                }

                @Override
                public Class<?> defineClass(ClassLoader classLoader, String name, byte[] binaryRepresentation, ProtectionDomain protectionDomain) {
                    throw new UnsupportedOperationException("Cannot define class using reflection", this.exception);
                }

                @Override
                public Package getPackage(ClassLoader classLoader, String name) {
                    throw new UnsupportedOperationException("Cannot get package using reflection", this.exception);
                }

                @Override
                public Package definePackage(ClassLoader classLoader, String name, String specificationTitle, String specificationVersion, String specificationVendor, String implementationTitle, String implementationVersion, String implementationVendor, URL sealBase) {
                    throw new UnsupportedOperationException("Cannot define package using injection", this.exception);
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Unavailable)) {
                        return false;
                    }
                    Unavailable other = (Unavailable)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Exception this$exception = this.exception;
                    Exception other$exception = other.exception;
                    return !(this$exception == null ? other$exception != null : !this$exception.equals(other$exception));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof Unavailable;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Exception $exception = this.exception;
                    result = result * 59 + ($exception == null ? 43 : $exception.hashCode());
                    return result;
                }
            }

            public static class Indirect
            implements Dispatcher,
            Initializable {
                private static final Permission ACCESS_PERMISSION = new ReflectPermission("suppressAccessChecks");
                private final Object accessor;
                private final Method findLoadedClass;
                private final Method defineClass;
                private final Method getPackage;
                private final Method definePackage;
                private final Method getClassLoadingLock;

                protected Indirect(Object accessor, Method findLoadedClass, Method defineClass, Method getPackage, Method definePackage, Method getClassLoadingLock) {
                    this.accessor = accessor;
                    this.findLoadedClass = findLoadedClass;
                    this.defineClass = defineClass;
                    this.getPackage = getPackage;
                    this.definePackage = definePackage;
                    this.getClassLoadingLock = getClassLoadingLock;
                }

                @Override
                public boolean isAvailable() {
                    return true;
                }

                @SuppressFBWarnings(value={"DP_DO_INSIDE_DO_PRIVILEGED"}, justification="Privilege is explicit caller responsibility")
                public static Initializable make() throws Exception {
                    Method getPackage;
                    Class<?> unsafe = Class.forName("sun.misc.Unsafe");
                    Field theUnsafe = unsafe.getDeclaredField("theUnsafe");
                    theUnsafe.setAccessible(true);
                    Object unsafeInstance = theUnsafe.get(null);
                    try {
                        getPackage = ClassLoader.class.getDeclaredMethod("getDeclaredPackage", String.class);
                    }
                    catch (NoSuchMethodException ignored) {
                        getPackage = ClassLoader.class.getDeclaredMethod("getPackage", String.class);
                    }
                    DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition builder = new ByteBuddy().subclass(Object.class, (ConstructorStrategy)ConstructorStrategy.Default.NO_CONSTRUCTORS).name(ClassLoader.class.getName() + "$ByteBuddyAccessor$" + RandomString.make()).defineMethod("findLoadedClass", (Type)((Object)Class.class), Visibility.PUBLIC).withParameters(new Type[]{ClassLoader.class, String.class}).intercept(MethodCall.invoke(ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class)).onArgument(0).withArgument(1)).defineMethod("defineClass", (Type)((Object)Class.class), Visibility.PUBLIC).withParameters(new Type[]{ClassLoader.class, String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class}).intercept(MethodCall.invoke(ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class)).onArgument(0).withArgument(1, 2, 3, 4, 5)).defineMethod("getPackage", (Type)((Object)Package.class), Visibility.PUBLIC).withParameters(new Type[]{ClassLoader.class, String.class}).intercept(MethodCall.invoke(getPackage).onArgument(0).withArgument(1)).defineMethod("definePackage", (Type)((Object)Package.class), Visibility.PUBLIC).withParameters(new Type[]{ClassLoader.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, URL.class}).intercept(MethodCall.invoke(ClassLoader.class.getDeclaredMethod("definePackage", String.class, String.class, String.class, String.class, String.class, String.class, String.class, URL.class)).onArgument(0).withArgument(1, 2, 3, 4, 5, 6, 7, 8));
                    try {
                        builder = builder.defineMethod("getClassLoadingLock", (Type)((Object)Object.class), Visibility.PUBLIC).withParameters(new Type[]{ClassLoader.class, String.class}).intercept(MethodCall.invoke(ClassLoader.class.getDeclaredMethod("getClassLoadingLock", String.class)).onArgument(0).withArgument(1));
                    }
                    catch (NoSuchMethodException ignored) {
                        builder = builder.defineMethod("getClassLoadingLock", (Type)((Object)Object.class), Visibility.PUBLIC).withParameters(new Type[]{ClassLoader.class, String.class}).intercept(FixedValue.argument(0));
                    }
                    Class type = builder.make().load(ClassLoadingStrategy.BOOTSTRAP_LOADER, new ClassLoadingStrategy.ForUnsafeInjection()).getLoaded();
                    return new Indirect(unsafe.getDeclaredMethod("allocateInstance", Class.class).invoke(unsafeInstance, type), type.getMethod("findLoadedClass", ClassLoader.class, String.class), type.getMethod("defineClass", ClassLoader.class, String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class), type.getMethod("getPackage", ClassLoader.class, String.class), type.getMethod("definePackage", ClassLoader.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, URL.class), type.getMethod("getClassLoadingLock", ClassLoader.class, String.class));
                }

                @Override
                public Dispatcher initialize() {
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        securityManager.checkPermission(ACCESS_PERMISSION);
                    }
                    return this;
                }

                @Override
                public Object getClassLoadingLock(ClassLoader classLoader, String name) {
                    try {
                        return this.getClassLoadingLock.invoke(this.accessor, classLoader, name);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Could not access (accessor)::getClassLoadingLock", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking (accessor)::getClassLoadingLock", exception.getCause());
                    }
                }

                @Override
                public Class<?> findClass(ClassLoader classLoader, String name) {
                    try {
                        return (Class)this.findLoadedClass.invoke(this.accessor, classLoader, name);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Could not access (accessor)::findLoadedClass", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking (accessor)::findLoadedClass", exception.getCause());
                    }
                }

                @Override
                public Class<?> defineClass(ClassLoader classLoader, String name, byte[] binaryRepresentation, ProtectionDomain protectionDomain) {
                    try {
                        return (Class)this.defineClass.invoke(this.accessor, classLoader, name, binaryRepresentation, 0, binaryRepresentation.length, protectionDomain);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Could not access (accessor)::defineClass", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking (accessor)::defineClass", exception.getCause());
                    }
                }

                @Override
                public Package getPackage(ClassLoader classLoader, String name) {
                    try {
                        return (Package)this.getPackage.invoke(this.accessor, classLoader, name);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Could not access (accessor)::getPackage", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking (accessor)::getPackage", exception.getCause());
                    }
                }

                @Override
                public Package definePackage(ClassLoader classLoader, String name, String specificationTitle, String specificationVersion, String specificationVendor, String implementationTitle, String implementationVersion, String implementationVendor, URL sealBase) {
                    try {
                        return (Package)this.definePackage.invoke(this.accessor, classLoader, name, specificationTitle, specificationVersion, specificationVendor, implementationTitle, implementationVersion, implementationVendor, sealBase);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Could not access (accessor)::definePackage", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking (accessor)::definePackage", exception.getCause());
                    }
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Indirect)) {
                        return false;
                    }
                    Indirect other = (Indirect)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Object this$accessor = this.accessor;
                    Object other$accessor = other.accessor;
                    if (this$accessor == null ? other$accessor != null : !this$accessor.equals(other$accessor)) {
                        return false;
                    }
                    Method this$findLoadedClass = this.findLoadedClass;
                    Method other$findLoadedClass = other.findLoadedClass;
                    if (this$findLoadedClass == null ? other$findLoadedClass != null : !((Object)this$findLoadedClass).equals(other$findLoadedClass)) {
                        return false;
                    }
                    Method this$defineClass = this.defineClass;
                    Method other$defineClass = other.defineClass;
                    if (this$defineClass == null ? other$defineClass != null : !((Object)this$defineClass).equals(other$defineClass)) {
                        return false;
                    }
                    Method this$getPackage = this.getPackage;
                    Method other$getPackage = other.getPackage;
                    if (this$getPackage == null ? other$getPackage != null : !((Object)this$getPackage).equals(other$getPackage)) {
                        return false;
                    }
                    Method this$definePackage = this.definePackage;
                    Method other$definePackage = other.definePackage;
                    if (this$definePackage == null ? other$definePackage != null : !((Object)this$definePackage).equals(other$definePackage)) {
                        return false;
                    }
                    Method this$getClassLoadingLock = this.getClassLoadingLock;
                    Method other$getClassLoadingLock = other.getClassLoadingLock;
                    return !(this$getClassLoadingLock == null ? other$getClassLoadingLock != null : !((Object)this$getClassLoadingLock).equals(other$getClassLoadingLock));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof Indirect;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Object $accessor = this.accessor;
                    result = result * 59 + ($accessor == null ? 43 : $accessor.hashCode());
                    Method $findLoadedClass = this.findLoadedClass;
                    result = result * 59 + ($findLoadedClass == null ? 43 : ((Object)$findLoadedClass).hashCode());
                    Method $defineClass = this.defineClass;
                    result = result * 59 + ($defineClass == null ? 43 : ((Object)$defineClass).hashCode());
                    Method $getPackage = this.getPackage;
                    result = result * 59 + ($getPackage == null ? 43 : ((Object)$getPackage).hashCode());
                    Method $definePackage = this.definePackage;
                    result = result * 59 + ($definePackage == null ? 43 : ((Object)$definePackage).hashCode());
                    Method $getClassLoadingLock = this.getClassLoadingLock;
                    result = result * 59 + ($getClassLoadingLock == null ? 43 : ((Object)$getClassLoadingLock).hashCode());
                    return result;
                }
            }

            public static abstract class Direct
            implements Dispatcher,
            Initializable {
                protected final Method findLoadedClass;
                protected final Method defineClass;
                protected final Method getPackage;
                protected final Method definePackage;

                protected Direct(Method findLoadedClass, Method defineClass, Method getPackage, Method definePackage) {
                    this.findLoadedClass = findLoadedClass;
                    this.defineClass = defineClass;
                    this.getPackage = getPackage;
                    this.definePackage = definePackage;
                }

                protected static Initializable make() throws Exception {
                    Method getPackage;
                    try {
                        getPackage = ClassLoader.class.getDeclaredMethod("getDefinedPackage", String.class);
                    }
                    catch (NoSuchMethodException ignored) {
                        getPackage = ClassLoader.class.getDeclaredMethod("getPackage", String.class);
                    }
                    Method findLoadedClass = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
                    Method defineClass = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
                    Method definePackage = ClassLoader.class.getDeclaredMethod("definePackage", String.class, String.class, String.class, String.class, String.class, String.class, String.class, URL.class);
                    try {
                        return new ForJava7CapableVm(findLoadedClass, defineClass, getPackage, definePackage, ClassLoader.class.getDeclaredMethod("getClassLoadingLock", String.class));
                    }
                    catch (NoSuchMethodException ignored) {
                        return new ForLegacyVm(findLoadedClass, defineClass, getPackage, definePackage);
                    }
                }

                @Override
                public Class<?> findClass(ClassLoader classLoader, String name) {
                    try {
                        return (Class)this.findLoadedClass.invoke((Object)classLoader, name);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Could not access java.lang.ClassLoader#findClass", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.ClassLoader#findClass", exception.getCause());
                    }
                }

                @Override
                public Class<?> defineClass(ClassLoader classLoader, String name, byte[] binaryRepresentation, ProtectionDomain protectionDomain) {
                    try {
                        return (Class)this.defineClass.invoke((Object)classLoader, name, binaryRepresentation, 0, binaryRepresentation.length, protectionDomain);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Could not access java.lang.ClassLoader#findClass", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.ClassLoader#findClass", exception.getCause());
                    }
                }

                @Override
                public Package getPackage(ClassLoader classLoader, String name) {
                    try {
                        return (Package)this.getPackage.invoke((Object)classLoader, name);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Could not access java.lang.ClassLoader#findClass", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.ClassLoader#findClass", exception.getCause());
                    }
                }

                @Override
                public Package definePackage(ClassLoader classLoader, String name, String specificationTitle, String specificationVersion, String specificationVendor, String implementationTitle, String implementationVersion, String implementationVendor, URL sealBase) {
                    try {
                        return (Package)this.definePackage.invoke((Object)classLoader, name, specificationTitle, specificationVersion, specificationVendor, implementationTitle, implementationVersion, implementationVendor, sealBase);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Could not access java.lang.ClassLoader#findClass", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.ClassLoader#findClass", exception.getCause());
                    }
                }

                @Override
                public boolean isAvailable() {
                    return true;
                }

                @Override
                @SuppressFBWarnings(value={"DP_DO_INSIDE_DO_PRIVILEGED", "REC_CATCH_EXCEPTION"}, justification="Privilege is explicit user responsibility")
                public Dispatcher initialize() {
                    try {
                        this.findLoadedClass.setAccessible(true);
                        this.defineClass.setAccessible(true);
                        this.getPackage.setAccessible(true);
                        this.definePackage.setAccessible(true);
                        this.onInitialization();
                        return this;
                    }
                    catch (Exception exception) {
                        return new Unavailable(exception);
                    }
                }

                protected abstract void onInitialization();

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Direct)) {
                        return false;
                    }
                    Direct other = (Direct)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Method this$findLoadedClass = this.findLoadedClass;
                    Method other$findLoadedClass = other.findLoadedClass;
                    if (this$findLoadedClass == null ? other$findLoadedClass != null : !((Object)this$findLoadedClass).equals(other$findLoadedClass)) {
                        return false;
                    }
                    Method this$defineClass = this.defineClass;
                    Method other$defineClass = other.defineClass;
                    if (this$defineClass == null ? other$defineClass != null : !((Object)this$defineClass).equals(other$defineClass)) {
                        return false;
                    }
                    Method this$getPackage = this.getPackage;
                    Method other$getPackage = other.getPackage;
                    if (this$getPackage == null ? other$getPackage != null : !((Object)this$getPackage).equals(other$getPackage)) {
                        return false;
                    }
                    Method this$definePackage = this.definePackage;
                    Method other$definePackage = other.definePackage;
                    return !(this$definePackage == null ? other$definePackage != null : !((Object)this$definePackage).equals(other$definePackage));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof Direct;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Method $findLoadedClass = this.findLoadedClass;
                    result = result * 59 + ($findLoadedClass == null ? 43 : ((Object)$findLoadedClass).hashCode());
                    Method $defineClass = this.defineClass;
                    result = result * 59 + ($defineClass == null ? 43 : ((Object)$defineClass).hashCode());
                    Method $getPackage = this.getPackage;
                    result = result * 59 + ($getPackage == null ? 43 : ((Object)$getPackage).hashCode());
                    Method $definePackage = this.definePackage;
                    result = result * 59 + ($definePackage == null ? 43 : ((Object)$definePackage).hashCode());
                    return result;
                }

                protected static class ForLegacyVm
                extends Direct {
                    protected ForLegacyVm(Method findLoadedClass, Method defineClass, Method getPackage, Method definePackage) {
                        super(findLoadedClass, defineClass, getPackage, definePackage);
                    }

                    @Override
                    public Object getClassLoadingLock(ClassLoader classLoader, String name) {
                        return classLoader;
                    }

                    @Override
                    protected void onInitialization() {
                    }
                }

                protected static class ForJava7CapableVm
                extends Direct {
                    private final Method getClassLoadingLock;

                    protected ForJava7CapableVm(Method findLoadedClass, Method defineClass, Method getPackage, Method definePackage, Method getClassLoadingLock) {
                        super(findLoadedClass, defineClass, getPackage, definePackage);
                        this.getClassLoadingLock = getClassLoadingLock;
                    }

                    @Override
                    public Object getClassLoadingLock(ClassLoader classLoader, String name) {
                        try {
                            return this.getClassLoadingLock.invoke((Object)classLoader, name);
                        }
                        catch (IllegalAccessException exception) {
                            throw new IllegalStateException("Could not access java.lang.ClassLoader#getClassLoadingLock", exception);
                        }
                        catch (InvocationTargetException exception) {
                            throw new IllegalStateException("Error invoking java.lang.ClassLoader#getClassLoadingLock", exception.getCause());
                        }
                    }

                    @Override
                    @SuppressFBWarnings(value={"DP_DO_INSIDE_DO_PRIVILEGED"}, justification="Privilege is explicit user responsibility")
                    protected void onInitialization() {
                        this.getClassLoadingLock.setAccessible(true);
                    }

                    @Override
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof ForJava7CapableVm)) {
                            return false;
                        }
                        ForJava7CapableVm other = (ForJava7CapableVm)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        if (!super.equals(o)) {
                            return false;
                        }
                        Method this$getClassLoadingLock = this.getClassLoadingLock;
                        Method other$getClassLoadingLock = other.getClassLoadingLock;
                        return !(this$getClassLoadingLock == null ? other$getClassLoadingLock != null : !((Object)this$getClassLoadingLock).equals(other$getClassLoadingLock));
                    }

                    @Override
                    protected boolean canEqual(Object other) {
                        return other instanceof ForJava7CapableVm;
                    }

                    @Override
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        result = result * 59 + super.hashCode();
                        Method $getClassLoadingLock = this.getClassLoadingLock;
                        result = result * 59 + ($getClassLoadingLock == null ? 43 : ((Object)$getClassLoadingLock).hashCode());
                        return result;
                    }
                }
            }

            public static enum CreationAction implements PrivilegedAction<Initializable>
            {
                INSTANCE;


                @Override
                @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should not be rethrown but trigger a fallback")
                public Initializable run() {
                    try {
                        return ClassFileVersion.ofThisVm().isAtLeast(ClassFileVersion.JAVA_V9) ? Indirect.make() : Direct.make();
                    }
                    catch (Exception exception) {
                        return new Unavailable(exception);
                    }
                }
            }

            public static interface Initializable {
                public boolean isAvailable();

                public Dispatcher initialize();
            }
        }
    }
}

