/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;
import org.redisson.RedissonSetMultimap;
import org.redisson.api.RSetMultimapReactive;
import org.redisson.api.RSetReactive;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandReactiveExecutor;
import org.redisson.reactive.RedissonBaseMultimapReactive;
import org.redisson.reactive.RedissonSetReactive;

public class RedissonSetMultimapReactive<K, V>
extends RedissonBaseMultimapReactive<K, V>
implements RSetMultimapReactive<K, V> {
    public RedissonSetMultimapReactive(UUID id, CommandReactiveExecutor commandExecutor, String name) {
        super(new RedissonSetMultimap(id, (CommandAsyncExecutor)commandExecutor, name), commandExecutor, name);
    }

    public RedissonSetMultimapReactive(UUID id, Codec codec, CommandReactiveExecutor commandExecutor, String name) {
        super(new RedissonSetMultimap(id, codec, commandExecutor, name), codec, commandExecutor, name);
    }

    @Override
    public RSetReactive<V> get(final K key) {
        ByteBuf keyState = this.encodeMapKey(key);
        String keyHash = this.hashAndRelease(keyState);
        final String setName = this.getValuesName(keyHash);
        return new RedissonSetReactive<V>(this.codec, this.commandExecutor, setName){

            @Override
            public Publisher<Boolean> delete() {
                ByteBuf keyState = this.encodeMapKey(key);
                return RedissonSetMultimapReactive.this.fastRemove(Arrays.asList(keyState), Arrays.asList(setName), RedisCommands.EVAL_BOOLEAN_AMOUNT);
            }

            @Override
            public Publisher<Boolean> clearExpire() {
                throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
            }

            @Override
            public Publisher<Boolean> expire(long timeToLive, TimeUnit timeUnit) {
                throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
            }

            @Override
            public Publisher<Boolean> expireAt(long timestamp) {
                throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
            }

            @Override
            public Publisher<Long> remainTimeToLive() {
                throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
            }

            @Override
            public Publisher<Void> rename(String newName) {
                throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
            }

            @Override
            public Publisher<Boolean> renamenx(String newName) {
                throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
            }
        };
    }

    @Override
    public Publisher<Set<V>> getAll(K key) {
        ByteBuf keyState = this.encodeMapKey(key);
        String keyHash = this.hashAndRelease(keyState);
        String setName = this.getValuesName(keyHash);
        return this.commandExecutor.readReactive(this.getName(), this.codec, RedisCommands.SMEMBERS, setName);
    }

    @Override
    public Publisher<Set<V>> removeAll(Object key) {
        ByteBuf keyState = this.encodeMapKey(key);
        String keyHash = this.hash(keyState);
        String setName = this.getValuesName(keyHash);
        return this.commandExecutor.evalWriteReactive(this.getName(), this.codec, RedisCommands.EVAL_SET, "redis.call('hdel', KEYS[1], ARGV[1]); local members = redis.call('smembers', KEYS[2]); redis.call('del', KEYS[2]); return members; ", Arrays.asList(this.getName(), setName), keyState);
    }

    @Override
    public Publisher<Set<V>> replaceValues(K key, Iterable<? extends V> values) {
        ArrayList<Object> params = new ArrayList<Object>();
        ByteBuf keyState = this.encodeMapKey(key);
        params.add(keyState);
        String keyHash = this.hash(keyState);
        params.add(keyHash);
        for (V value : values) {
            ByteBuf valueState = this.encodeMapValue(value);
            params.add(valueState);
        }
        String setName = this.getValuesName(keyHash);
        return this.commandExecutor.evalWriteReactive(this.getName(), this.codec, RedisCommands.EVAL_SET, "redis.call('hset', KEYS[1], ARGV[1], ARGV[2]); local members = redis.call('smembers', KEYS[2]); redis.call('del', KEYS[2]); redis.call('sadd', KEYS[2], unpack(ARGV, 3, #ARGV)); return members; ", Arrays.asList(this.getName(), setName), params.toArray());
    }
}

