/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;
import org.redisson.RedissonListMultimap;
import org.redisson.api.RListMultimapReactive;
import org.redisson.api.RListReactive;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandReactiveExecutor;
import org.redisson.reactive.RedissonBaseMultimapReactive;
import org.redisson.reactive.RedissonListReactive;

public class RedissonListMultimapReactive<K, V>
extends RedissonBaseMultimapReactive<K, V>
implements RListMultimapReactive<K, V> {
    public RedissonListMultimapReactive(UUID id, CommandReactiveExecutor commandExecutor, String name) {
        super(new RedissonListMultimap(id, (CommandAsyncExecutor)commandExecutor, name), commandExecutor, name);
    }

    public RedissonListMultimapReactive(UUID id, Codec codec, CommandReactiveExecutor commandExecutor, String name) {
        super(new RedissonListMultimap(id, codec, commandExecutor, name), codec, commandExecutor, name);
    }

    @Override
    public RListReactive<V> get(final K key) {
        ByteBuf keyState = this.encodeMapKey(key);
        String keyHash = this.hashAndRelease(keyState);
        final String setName = this.getValuesName(keyHash);
        return new RedissonListReactive<V>(this.codec, this.commandExecutor, setName){

            @Override
            public Publisher<Boolean> delete() {
                ByteBuf keyState = this.encodeMapKey(key);
                return RedissonListMultimapReactive.this.fastRemove(Arrays.asList(keyState), Arrays.asList(setName), RedisCommands.EVAL_BOOLEAN_AMOUNT);
            }

            @Override
            public Publisher<Boolean> clearExpire() {
                throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
            }

            @Override
            public Publisher<Boolean> expire(long timeToLive, TimeUnit timeUnit) {
                throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
            }

            @Override
            public Publisher<Boolean> expireAt(long timestamp) {
                throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
            }

            @Override
            public Publisher<Long> remainTimeToLive() {
                throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
            }

            @Override
            public Publisher<Void> rename(String newName) {
                throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
            }

            @Override
            public Publisher<Boolean> renamenx(String newName) {
                throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
            }
        };
    }

    @Override
    public Publisher<List<V>> getAll(K key) {
        ByteBuf keyState = this.encodeMapKey(key);
        String keyHash = this.hashAndRelease(keyState);
        String setName = this.getValuesName(keyHash);
        return this.commandExecutor.readReactive(this.getName(), this.codec, RedisCommands.LRANGE, setName, 0, -1);
    }

    @Override
    public Publisher<List<V>> removeAll(Object key) {
        ByteBuf keyState = this.encodeMapKey(key);
        String keyHash = this.hash(keyState);
        String setName = this.getValuesName(keyHash);
        return this.commandExecutor.evalWriteReactive(this.getName(), this.codec, RedisCommands.EVAL_LIST, "redis.call('hdel', KEYS[1], ARGV[1]); local members = redis.call('lrange', KEYS[2], 0, -1); redis.call('del', KEYS[2]); return members; ", Arrays.asList(this.getName(), setName), keyState);
    }

    @Override
    public Publisher<List<V>> replaceValues(K key, Iterable<? extends V> values) {
        ArrayList<Object> params = new ArrayList<Object>();
        ByteBuf keyState = this.encodeMapKey(key);
        params.add(keyState);
        String keyHash = this.hash(keyState);
        params.add(keyHash);
        for (V value : values) {
            ByteBuf valueState = this.encodeMapValue(value);
            params.add(valueState);
        }
        String setName = this.getValuesName(keyHash);
        return this.commandExecutor.evalWriteReactive(this.getName(), this.codec, RedisCommands.EVAL_LIST, "redis.call('hset', KEYS[1], ARGV[1], ARGV[2]); local members = redis.call('lrange', KEYS[2], 0, -1); redis.call('del', KEYS[2]); redis.call('rpush', KEYS[2], unpack(ARGV, 3, #ARGV)); return members; ", Arrays.asList(this.getName(), setName), params.toArray());
    }
}

