/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.mapreduce;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RList;
import org.redisson.api.RListMultimap;
import org.redisson.api.RMap;
import org.redisson.api.RedissonClient;
import org.redisson.api.annotation.RInject;
import org.redisson.api.mapreduce.RReducer;
import org.redisson.client.codec.Codec;
import org.redisson.misc.Injector;

public class ReducerTask<KOut, VOut>
implements Runnable,
Serializable {
    private static final long serialVersionUID = 3556632668150314703L;
    @RInject
    private RedissonClient redisson;
    private String name;
    private String resultMapName;
    private RReducer<KOut, VOut> reducer;
    private Class<?> codecClass;
    private Codec codec;
    private long timeout;

    public ReducerTask() {
    }

    public ReducerTask(String name, RReducer<KOut, VOut> reducer, Class<?> codecClass, String resultMapName, long timeout) {
        this.name = name;
        this.reducer = reducer;
        this.resultMapName = resultMapName;
        this.codecClass = codecClass;
        this.timeout = timeout;
    }

    @Override
    public void run() {
        try {
            this.codec = (Codec)this.codecClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        Injector.inject(this.reducer, this.redisson);
        RMap map = this.redisson.getMap(this.resultMapName);
        RListMultimap multimap = this.redisson.getListMultimap(this.name, this.codec);
        for (Object key : multimap.keySet()) {
            if (Thread.currentThread().isInterrupted()) break;
            RList values = multimap.get(key);
            VOut out = this.reducer.reduce(key, values.iterator());
            map.put(key, out);
        }
        if (this.timeout > 0L) {
            map.expire(this.timeout, TimeUnit.MILLISECONDS);
        }
        multimap.delete();
    }
}

