/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.support;

import org.redisson.api.RDestroyable;
import org.redisson.client.codec.Codec;
import org.redisson.spring.support.AbstractRedissonNamespaceDefinitionParser;
import org.redisson.spring.support.RedissonNamespaceDecorator;
import org.redisson.spring.support.RedissonNamespaceParserSupport;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.Conventions;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class RedissonGenericObjectDefinitionParser
extends AbstractRedissonNamespaceDefinitionParser {
    private static final String KEY_ATTRIBUTE = "key";
    private static final String TOPIC_ATTRIBUTE = "topic";
    private static final String PATTERN_ATTRIBUTE = "pattern";
    private static final String SERVICE_ATTRIBUTE = "service";
    private static final String CODEC_REF_ATTRIBUTE = "codec-ref";
    private static final String FAIL_LOCK = "fairLock";

    RedissonGenericObjectDefinitionParser(RedissonNamespaceParserSupport helper) {
        super(helper, "redisson-ref");
    }

    RedissonGenericObjectDefinitionParser(RedissonNamespaceParserSupport helper, RedissonNamespaceDecorator decorator) {
        super(helper, "redisson-ref", decorator);
    }

    @Override
    protected void parseNested(Element element, ParserContext parserContext, BeanDefinitionBuilder builder, BeanDefinition bd) {
        bd.setFactoryBeanName(element.getAttribute("redisson-ref"));
        String typeName = Conventions.attributeNameToPropertyName((String)element.getLocalName());
        bd.setFactoryMethodName("get" + StringUtils.capitalize((String)typeName));
        this.helper.addConstructorArgs(element, KEY_ATTRIBUTE, String.class, builder);
        this.helper.addConstructorArgs(element, TOPIC_ATTRIBUTE, String.class, builder);
        this.helper.addConstructorArgs(element, PATTERN_ATTRIBUTE, String.class, builder);
        this.helper.addConstructorArgs(element, SERVICE_ATTRIBUTE, String.class, builder);
        this.helper.addConstructorArgs(element, CODEC_REF_ATTRIBUTE, Codec.class, builder);
        if (RDestroyable.class.isAssignableFrom(this.getBeanClass(element))) {
            ((AbstractBeanDefinition)bd).setDestroyMethodName("destroy");
        }
    }

    protected Class<?> getBeanClass(Element element) {
        String elementName = Conventions.attributeNameToPropertyName((String)element.getLocalName());
        try {
            return Class.forName("org.redisson.api.R" + StringUtils.capitalize((String)(FAIL_LOCK.equals(elementName) ? "lock" : elementName)));
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException(ex);
        }
    }
}

