/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import java.util.Collections;
import java.util.List;
import org.reactivestreams.Publisher;
import org.redisson.PubSubPatternMessageListener;
import org.redisson.PubSubPatternStatusListener;
import org.redisson.api.RFuture;
import org.redisson.api.RPatternTopicReactive;
import org.redisson.api.listener.PatternMessageListener;
import org.redisson.api.listener.PatternStatusListener;
import org.redisson.client.RedisPubSubListener;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandReactiveExecutor;
import org.redisson.connection.PubSubConnectionEntry;
import org.redisson.misc.RPromise;
import org.redisson.pubsub.AsyncSemaphore;
import org.redisson.reactive.NettyFuturePublisher;
import reactor.fn.Supplier;

public class RedissonPatternTopicReactive<M>
implements RPatternTopicReactive<M> {
    final CommandReactiveExecutor commandExecutor;
    private final String name;
    private final Codec codec;

    public RedissonPatternTopicReactive(CommandReactiveExecutor commandExecutor, String name) {
        this(commandExecutor.getConnectionManager().getCodec(), commandExecutor, name);
    }

    public RedissonPatternTopicReactive(Codec codec, CommandReactiveExecutor commandExecutor, String name) {
        this.commandExecutor = commandExecutor;
        this.name = name;
        this.codec = codec;
    }

    @Override
    public Publisher<Integer> addListener(final PatternStatusListener listener) {
        return new NettyFuturePublisher<Integer>(new Supplier<RFuture<Integer>>(){

            @Override
            public RFuture<Integer> get() {
                RPromise<Integer> promise = RedissonPatternTopicReactive.this.commandExecutor.getConnectionManager().newPromise();
                RedissonPatternTopicReactive.this.addListener(new PubSubPatternStatusListener(listener, RedissonPatternTopicReactive.this.name), promise);
                return promise;
            }
        });
    }

    @Override
    public Publisher<Integer> addListener(final PatternMessageListener<M> listener) {
        return new NettyFuturePublisher<Integer>(new Supplier<RFuture<Integer>>(){

            @Override
            public RFuture<Integer> get() {
                RPromise<Integer> promise = RedissonPatternTopicReactive.this.commandExecutor.getConnectionManager().newPromise();
                PubSubPatternMessageListener pubSubListener = new PubSubPatternMessageListener(listener, RedissonPatternTopicReactive.this.name);
                RedissonPatternTopicReactive.this.addListener(pubSubListener, promise);
                return promise;
            }
        });
    }

    private void addListener(final RedisPubSubListener<M> pubSubListener, final RPromise<Integer> promise) {
        RFuture<PubSubConnectionEntry> future = this.commandExecutor.getConnectionManager().psubscribe(this.name, this.codec, pubSubListener);
        future.addListener(new FutureListener<PubSubConnectionEntry>(){

            @Override
            public void operationComplete(Future<PubSubConnectionEntry> future) throws Exception {
                if (!future.isSuccess()) {
                    promise.tryFailure(future.cause());
                    return;
                }
                promise.trySuccess(pubSubListener.hashCode());
            }
        });
    }

    @Override
    public void removeListener(int listenerId) {
        AsyncSemaphore semaphore = this.commandExecutor.getConnectionManager().getSemaphore(this.name);
        semaphore.acquireUninterruptibly();
        PubSubConnectionEntry entry = this.commandExecutor.getConnectionManager().getPubSubEntry(this.name);
        if (entry == null) {
            semaphore.release();
            return;
        }
        entry.removeListener(this.name, listenerId);
        if (!entry.hasListeners(this.name)) {
            this.commandExecutor.getConnectionManager().punsubscribe(this.name, semaphore);
        } else {
            semaphore.release();
        }
    }

    @Override
    public List<String> getPatternNames() {
        return Collections.singletonList(this.name);
    }
}

