/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.buffer.ByteBuf;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.client.protocol.decoder.ScanObjectEntry;

abstract class RedissonBaseIterator<V>
implements Iterator<V> {
    private List<ByteBuf> firstValues;
    private List<ByteBuf> lastValues;
    private Iterator<ScanObjectEntry> lastIter;
    protected long nextIterPos;
    protected InetSocketAddress client;
    private boolean finished;
    private boolean currentElementRemoved;
    private V value;

    RedissonBaseIterator() {
    }

    @Override
    public boolean hasNext() {
        if (this.lastIter == null || !this.lastIter.hasNext()) {
            if (this.finished) {
                this.free(this.firstValues);
                this.free(this.lastValues);
                this.currentElementRemoved = false;
                this.client = null;
                this.firstValues = null;
                this.lastValues = null;
                this.nextIterPos = 0L;
                if (!this.tryAgain()) {
                    return false;
                }
                this.finished = false;
            }
            do {
                ListScanResult<ScanObjectEntry> res = this.iterator(this.client, this.nextIterPos);
                if (this.lastValues != null) {
                    this.free(this.lastValues);
                }
                this.lastValues = this.convert(res.getValues());
                this.client = res.getRedisClient();
                if (this.nextIterPos == 0L && this.firstValues == null) {
                    this.firstValues = this.lastValues;
                    this.lastValues = null;
                    if (this.firstValues.isEmpty() && this.tryAgain()) {
                        this.client = null;
                        this.firstValues = null;
                        this.nextIterPos = 0L;
                    }
                } else if (this.firstValues.isEmpty()) {
                    this.firstValues = this.lastValues;
                    this.lastValues = null;
                    if (this.firstValues.isEmpty()) {
                        if (this.tryAgain()) {
                            this.client = null;
                            this.firstValues = null;
                            this.nextIterPos = 0L;
                            continue;
                        }
                        if (res.getPos() == 0L) {
                            this.free(this.firstValues);
                            this.free(this.lastValues);
                            this.finished = true;
                            return false;
                        }
                    }
                } else if (this.lastValues.removeAll(this.firstValues) || this.lastValues.isEmpty() && this.nextIterPos == 0L) {
                    this.free(this.firstValues);
                    this.free(this.lastValues);
                    this.currentElementRemoved = false;
                    this.client = null;
                    this.firstValues = null;
                    this.lastValues = null;
                    this.nextIterPos = 0L;
                    if (this.tryAgain()) continue;
                    this.finished = true;
                    return false;
                }
                this.lastIter = res.getValues().iterator();
                this.nextIterPos = res.getPos();
            } while (!this.lastIter.hasNext());
        }
        return this.lastIter.hasNext();
    }

    private List<ByteBuf> convert(List<ScanObjectEntry> list) {
        ArrayList<ByteBuf> result = new ArrayList<ByteBuf>(list.size());
        for (ScanObjectEntry entry : list) {
            result.add(entry.getBuf());
        }
        return result;
    }

    private void free(List<ByteBuf> list) {
        if (list == null) {
            return;
        }
        for (ByteBuf byteBuf : list) {
            byteBuf.release();
        }
    }

    protected boolean tryAgain() {
        return false;
    }

    abstract ListScanResult<ScanObjectEntry> iterator(InetSocketAddress var1, long var2);

    @Override
    public V next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No such element");
        }
        this.value = this.lastIter.next().getObj();
        this.currentElementRemoved = false;
        return this.value;
    }

    @Override
    public void remove() {
        if (this.currentElementRemoved) {
            throw new IllegalStateException("Element been already deleted");
        }
        if (this.lastIter == null) {
            throw new IllegalStateException();
        }
        this.firstValues.remove(this.value);
        this.lastIter.remove();
        this.remove(this.value);
        this.currentElementRemoved = true;
    }

    abstract void remove(V var1);
}

