/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.stream;

import java.util.Iterator;
import org.reactivestreams.Subscriber;
import reactor.core.reactivestreams.PublisherFactory;
import reactor.core.reactivestreams.SubscriberWithContext;
import reactor.fn.Consumer;
import reactor.fn.Function;
import reactor.rx.Stream;
import reactor.rx.Streams;

public final class IterableStream<T> {
    public static <T> Stream<T> create(final Iterable<? extends T> defaultValues) {
        return Streams.wrap(PublisherFactory.forEach(new Consumer<SubscriberWithContext<T, Iterator<? extends T>>>(){

            @Override
            public void accept(SubscriberWithContext<T, Iterator<? extends T>> subscriber) {
                Iterator iterator = subscriber.context();
                if (!iterator.hasNext()) {
                    subscriber.onComplete();
                    return;
                }
                subscriber.onNext(iterator.next());
                if (!iterator.hasNext()) {
                    subscriber.onComplete();
                }
            }
        }, new Function<Subscriber<? super T>, Iterator<? extends T>>(){

            @Override
            public Iterator<? extends T> apply(Subscriber<? super T> subscriber) {
                if (defaultValues == null) {
                    subscriber.onComplete();
                    throw PublisherFactory.PrematureCompleteException.INSTANCE;
                }
                return defaultValues.iterator();
            }
        }));
    }
}

