/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.support;

import org.redisson.spring.misc.BeanMethodInvoker;
import org.redisson.spring.support.AbstractRedissonNamespaceDefinitionParser;
import org.redisson.spring.support.RedissonNamespaceParserSupport;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import reactor.core.support.Assert;

public class RedissonRPCServerDefinitionParser
extends AbstractRedissonNamespaceDefinitionParser {
    public RedissonRPCServerDefinitionParser(RedissonNamespaceParserSupport helper) {
        super(helper, "remote-service-ref");
    }

    @Override
    protected void parseNested(Element element, ParserContext parserContext, BeanDefinitionBuilder builder, BeanDefinition bd) {
        Class<?> apiClass;
        try {
            apiClass = Class.forName(this.helper.getAttribute(element, "api-class"));
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("The class [" + this.helper.getAttribute(element, "api-class") + "] specified in \"" + "api-class" + "\" attribute has not " + "found. Please check the class path.", ex);
        }
        builder.addPropertyValue("targetObject", (Object)new RuntimeBeanReference(this.helper.getAttribute(element, "remote-service-ref")));
        builder.addPropertyValue("targetMethod", (Object)"register");
        ManagedList args = new ManagedList();
        args.add(apiClass);
        args.add((Object)new RuntimeBeanReference(this.helper.getAttribute(element, "bean")));
        String workers = null;
        if (this.helper.hasAttribute(element, "concurrent-workers")) {
            workers = this.helper.getAttribute(element, "concurrent-workers");
        }
        if (StringUtils.hasText(workers)) {
            args.add((Object)Integer.parseInt(workers));
        }
        if (this.helper.hasAttribute(element, "executor-ref")) {
            Assert.state(this.helper.hasAttribute(element, "concurrent-workers"), "The \"concurrent-workers\" attribute in \"rpc-server\" element is required when \"executor-ref\" attribute is specified.");
            args.add((Object)new RuntimeBeanReference(this.helper.getAttribute(element, "executor-ref")));
        }
        builder.addPropertyValue("arguments", (Object)args);
    }

    protected Class<?> getBeanClass(Element element) {
        return BeanMethodInvoker.class;
    }
}

